/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.connectionfactory.init;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.data.r2dbc.connectionfactory.init.DatabasePopulator;
import org.springframework.data.r2dbc.connectionfactory.init.DatabasePopulatorUtils;
import org.springframework.data.r2dbc.connectionfactory.init.ScriptException;
import org.springframework.data.r2dbc.connectionfactory.init.ScriptUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Deprecated
public class ResourceDatabasePopulator
implements DatabasePopulator {
    List<Resource> scripts = new ArrayList<Resource>();
    @Nullable
    private Charset sqlScriptEncoding;
    private String separator = ";";
    private String commentPrefix = "--";
    private String blockCommentStartDelimiter = "/*";
    private String blockCommentEndDelimiter = "*/";
    private boolean continueOnError = false;
    private boolean ignoreFailedDrops = false;
    private DataBufferFactory dataBufferFactory = new DefaultDataBufferFactory();

    public ResourceDatabasePopulator() {
    }

    public ResourceDatabasePopulator(Resource ... scripts) {
        this.setScripts(scripts);
    }

    public ResourceDatabasePopulator(boolean continueOnError, boolean ignoreFailedDrops, @Nullable String sqlScriptEncoding, Resource ... scripts) {
        this.continueOnError = continueOnError;
        this.ignoreFailedDrops = ignoreFailedDrops;
        this.setSqlScriptEncoding(sqlScriptEncoding);
        this.setScripts(scripts);
    }

    public void addScript(Resource script) {
        Assert.notNull((Object)script, (String)"Script must not be null");
        this.scripts.add(script);
    }

    public void addScripts(Resource ... scripts) {
        this.assertContentsOfScriptArray(scripts);
        this.scripts.addAll(Arrays.asList(scripts));
    }

    public void setScripts(Resource ... scripts) {
        this.assertContentsOfScriptArray(scripts);
        this.scripts = new ArrayList<Resource>(Arrays.asList(scripts));
    }

    private void assertContentsOfScriptArray(Resource ... scripts) {
        Assert.notNull((Object)scripts, (String)"Scripts array must not be null");
        Assert.noNullElements((Object[])scripts, (String)"Scripts array must not contain null elements");
    }

    public void setSqlScriptEncoding(@Nullable String sqlScriptEncoding) {
        this.setSqlScriptEncoding(StringUtils.hasText((String)sqlScriptEncoding) ? Charset.forName(sqlScriptEncoding) : null);
    }

    public void setSqlScriptEncoding(@Nullable Charset sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setCommentPrefix(String commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    public void setBlockCommentStartDelimiter(String blockCommentStartDelimiter) {
        Assert.hasText((String)blockCommentStartDelimiter, (String)"BlockCommentStartDelimiter must not be null or empty");
        this.blockCommentStartDelimiter = blockCommentStartDelimiter;
    }

    public void setBlockCommentEndDelimiter(String blockCommentEndDelimiter) {
        Assert.hasText((String)blockCommentEndDelimiter, (String)"BlockCommentEndDelimiter must not be null or empty");
        this.blockCommentEndDelimiter = blockCommentEndDelimiter;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setIgnoreFailedDrops(boolean ignoreFailedDrops) {
        this.ignoreFailedDrops = ignoreFailedDrops;
    }

    public void setDataBufferFactory(DataBufferFactory dataBufferFactory) {
        Assert.notNull((Object)dataBufferFactory, (String)"DataBufferFactory must not be null!");
        this.dataBufferFactory = dataBufferFactory;
    }

    @Override
    public Mono<Void> populate(Connection connection) throws ScriptException {
        Assert.notNull((Object)connection, (String)"Connection must not be null");
        return Flux.fromIterable(this.scripts).concatMap(it -> {
            EncodedResource encodedScript = new EncodedResource(it, this.sqlScriptEncoding);
            return ScriptUtils.executeSqlScript(connection, encodedScript, this.dataBufferFactory, this.continueOnError, this.ignoreFailedDrops, this.commentPrefix, this.separator, this.blockCommentStartDelimiter, this.blockCommentEndDelimiter);
        }).then();
    }

    public Mono<Void> execute(ConnectionFactory connectionFactory) throws ScriptException {
        return DatabasePopulatorUtils.execute(this, connectionFactory);
    }
}

