/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.repository.query.AbstractR2dbcQuery;
import org.springframework.data.r2dbc.repository.query.BindableQuery;
import org.springframework.data.r2dbc.repository.query.ExpressionEvaluatingParameterBinder;
import org.springframework.data.r2dbc.repository.query.ExpressionQuery;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class StringBasedR2dbcQuery
extends AbstractR2dbcQuery {
    private final ExpressionQuery expressionQuery;
    private final ExpressionEvaluatingParameterBinder binder;

    public StringBasedR2dbcQuery(R2dbcQueryMethod queryMethod, DatabaseClient databaseClient, R2dbcConverter converter, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getRequiredAnnotatedQuery(), queryMethod, databaseClient, converter, expressionParser, evaluationContextProvider);
    }

    public StringBasedR2dbcQuery(String query, R2dbcQueryMethod method, DatabaseClient databaseClient, R2dbcConverter converter, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, databaseClient, converter);
        Assert.hasText((String)query, (String)"Query must not be empty");
        this.expressionQuery = ExpressionQuery.create(query);
        this.binder = new ExpressionEvaluatingParameterBinder(expressionParser, evaluationContextProvider, this.expressionQuery);
    }

    @Override
    protected boolean isModifyingQuery() {
        return this.getQueryMethod().isModifyingQuery();
    }

    @Override
    protected BindableQuery createQuery(final RelationalParameterAccessor accessor) {
        return new BindableQuery(){

            @Override
            public <T extends DatabaseClient.BindSpec<T>> T bind(T bindSpec) {
                return StringBasedR2dbcQuery.this.binder.bind(bindSpec, accessor);
            }

            @Override
            public String get() {
                return StringBasedR2dbcQuery.this.expressionQuery.getQuery();
            }
        };
    }
}

