/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Statement;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.r2dbc.core.DefaultDatabaseClientBuilder;
import org.springframework.data.r2dbc.core.ExecuteFunction;
import org.springframework.data.r2dbc.core.FetchSpec;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.RowsFetchSpec;
import org.springframework.data.r2dbc.core.StatementFilterFunction;
import org.springframework.data.r2dbc.core.UpdatedRowsFetchSpec;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.data.r2dbc.query.Update;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public interface DatabaseClient {
    public GenericExecuteSpec execute(String var1);

    public GenericExecuteSpec execute(Supplier<String> var1);

    public SelectFromSpec select();

    public InsertIntoSpec insert();

    public UpdateTableSpec update();

    public DeleteFromSpec delete();

    public Builder mutate();

    public static DatabaseClient create(ConnectionFactory factory) {
        return new DefaultDatabaseClientBuilder().connectionFactory(factory).build();
    }

    public static Builder builder() {
        return new DefaultDatabaseClientBuilder();
    }

    public static interface StatementFilterSpec<S extends StatementFilterSpec<S>> {
        default public S filter(Function<? super Statement, ? extends Statement> filter) {
            Assert.notNull(filter, (String)"Statement FilterFunction must not be null!");
            return this.filter((Statement statement, ExecuteFunction next) -> next.execute((Statement)filter.apply(statement)));
        }

        public S filter(StatementFilterFunction var1);
    }

    public static interface BindSpec<S extends BindSpec<S>> {
        public S bind(int var1, Object var2);

        public S bindNull(int var1, Class<?> var2);

        public S bind(String var1, Object var2);

        public S bindNull(String var1, Class<?> var2);
    }

    public static interface DeleteSpec {
        public UpdatedRowsFetchSpec fetch();

        public Mono<Void> then();
    }

    public static interface DeleteMatchingSpec
    extends DeleteSpec {
        public DeleteSpec matching(CriteriaDefinition var1);
    }

    public static interface TypedDeleteSpec<T>
    extends DeleteSpec {
        default public TypedDeleteSpec<T> table(String tableName) {
            return this.table(SqlIdentifier.unquoted((String)tableName));
        }

        public TypedDeleteSpec<T> table(SqlIdentifier var1);

        public DeleteSpec matching(CriteriaDefinition var1);
    }

    public static interface UpdateSpec {
        public UpdatedRowsFetchSpec fetch();

        public Mono<Void> then();
    }

    public static interface UpdateMatchingSpec
    extends UpdateSpec {
        public UpdateSpec matching(CriteriaDefinition var1);
    }

    public static interface TypedUpdateSpec<T> {
        public UpdateMatchingSpec using(T var1);

        default public TypedUpdateSpec<T> table(String tableName) {
            return this.table(SqlIdentifier.unquoted((String)tableName));
        }

        public TypedUpdateSpec<T> table(SqlIdentifier var1);
    }

    public static interface GenericUpdateSpec {
        @Deprecated
        public UpdateMatchingSpec using(Update var1);

        public UpdateMatchingSpec using(org.springframework.data.relational.core.query.Update var1);
    }

    public static interface InsertSpec<T> {
        public <R> RowsFetchSpec<R> map(Function<Row, R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<T> fetch();

        public Mono<Void> then();
    }

    public static interface TypedInsertSpec<T> {
        public InsertSpec<Map<String, Object>> using(T var1);

        default public TypedInsertSpec<T> table(String tableName) {
            return this.table(SqlIdentifier.unquoted((String)tableName));
        }

        public TypedInsertSpec<T> table(SqlIdentifier var1);

        public InsertSpec<Map<String, Object>> using(Publisher<T> var1);
    }

    public static interface GenericInsertSpec<T>
    extends InsertSpec<T> {
        default public GenericInsertSpec<T> value(String field, Object value) {
            return this.value(SqlIdentifier.unquoted((String)field), value);
        }

        public GenericInsertSpec<T> value(SqlIdentifier var1, Object var2);

        default public GenericInsertSpec<T> nullValue(String field, Class<?> type) {
            return this.nullValue(SqlIdentifier.unquoted((String)field), type);
        }

        default public GenericInsertSpec<T> nullValue(SqlIdentifier field, Class<?> type) {
            return this.value(field, (Object)SettableValue.empty(type));
        }
    }

    public static interface SelectSpec<S extends SelectSpec<S>> {
        default public S project(String ... selectedFields) {
            return this.project((SqlIdentifier[])Arrays.stream(selectedFields).map(SqlIdentifier::unquoted).toArray(SqlIdentifier[]::new));
        }

        public S project(SqlIdentifier ... var1);

        public S matching(CriteriaDefinition var1);

        public S orderBy(Sort var1);

        default public S orderBy(Sort.Order ... orders) {
            return this.orderBy(Sort.by((Sort.Order[])orders));
        }

        public S page(Pageable var1);
    }

    public static interface TypedSelectSpec<T>
    extends SelectSpec<TypedSelectSpec<T>> {
        public <R> RowsFetchSpec<R> as(Class<R> var1);

        public <R> RowsFetchSpec<R> map(Function<Row, R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<T> fetch();
    }

    public static interface GenericSelectSpec
    extends SelectSpec<GenericSelectSpec> {
        public <R> TypedSelectSpec<R> as(Class<R> var1);

        public <R> RowsFetchSpec<R> map(Function<Row, R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<Map<String, Object>> fetch();
    }

    public static interface DeleteFromSpec {
        default public DeleteMatchingSpec from(String table) {
            return this.from(SqlIdentifier.unquoted((String)table));
        }

        public DeleteMatchingSpec from(SqlIdentifier var1);

        public <T> TypedDeleteSpec<T> from(Class<T> var1);
    }

    public static interface UpdateTableSpec {
        default public GenericUpdateSpec table(String table) {
            return this.table(SqlIdentifier.unquoted((String)table));
        }

        public GenericUpdateSpec table(SqlIdentifier var1);

        public <T> TypedUpdateSpec<T> table(Class<T> var1);
    }

    public static interface InsertIntoSpec {
        default public GenericInsertSpec<Map<String, Object>> into(String table) {
            return this.into(SqlIdentifier.unquoted((String)table));
        }

        public GenericInsertSpec<Map<String, Object>> into(SqlIdentifier var1);

        public <T> TypedInsertSpec<T> into(Class<T> var1);
    }

    public static interface SelectFromSpec {
        default public GenericSelectSpec from(String table) {
            return this.from(SqlIdentifier.unquoted((String)table));
        }

        public GenericSelectSpec from(SqlIdentifier var1);

        public <T> TypedSelectSpec<T> from(Class<T> var1);
    }

    public static interface TypedExecuteSpec<T>
    extends BindSpec<TypedExecuteSpec<T>>,
    StatementFilterSpec<TypedExecuteSpec<T>> {
        public <R> TypedExecuteSpec<R> as(Class<R> var1);

        public <R> RowsFetchSpec<R> map(Function<Row, R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<T> fetch();

        public Mono<Void> then();
    }

    public static interface GenericExecuteSpec
    extends BindSpec<GenericExecuteSpec>,
    StatementFilterSpec<GenericExecuteSpec> {
        public <R> TypedExecuteSpec<R> as(Class<R> var1);

        public <R> RowsFetchSpec<R> map(Function<Row, R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<Map<String, Object>> fetch();

        public Mono<Void> then();
    }

    public static interface Builder {
        public Builder connectionFactory(ConnectionFactory var1);

        public Builder exceptionTranslator(R2dbcExceptionTranslator var1);

        public Builder executeFunction(ExecuteFunction var1);

        public Builder dataAccessStrategy(ReactiveDataAccessStrategy var1);

        public Builder namedParameters(boolean var1);

        public Builder projectionFactory(ProjectionFactory var1);

        public Builder apply(Consumer<Builder> var1);

        public DatabaseClient build();
    }
}

