/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.connectionfactory;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.data.r2dbc.connectionfactory.ConnectionFactoryUtils;
import org.springframework.data.r2dbc.connectionfactory.ConnectionProxy;
import org.springframework.data.r2dbc.connectionfactory.DelegatingConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Mono;

public class TransactionAwareConnectionFactoryProxy
extends DelegatingConnectionFactory {
    public TransactionAwareConnectionFactoryProxy(ConnectionFactory targetConnectionFactory) {
        super(targetConnectionFactory);
    }

    public Mono<Connection> create() {
        return this.getTransactionAwareConnectionProxy(this.obtainTargetConnectionFactory());
    }

    protected Mono<Connection> getTransactionAwareConnectionProxy(ConnectionFactory targetConnectionFactory) {
        return ConnectionFactoryUtils.getConnection(targetConnectionFactory).map(it -> TransactionAwareConnectionFactoryProxy.proxyConnection(it, targetConnectionFactory));
    }

    private static Connection proxyConnection(Connection connection, ConnectionFactory targetConnectionFactory) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new TransactionAwareInvocationHandler(connection, targetConnectionFactory));
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final Connection connection;
        private final ConnectionFactory targetConnectionFactory;
        private boolean closed = false;

        TransactionAwareInvocationHandler(Connection connection, ConnectionFactory targetConnectionFactory) {
            this.connection = connection;
            this.targetConnectionFactory = targetConnectionFactory;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (ReflectionUtils.isObjectMethod((Method)method)) {
                if (ReflectionUtils.isToStringMethod((Method)method)) {
                    return this.proxyToString(proxy);
                }
                if (ReflectionUtils.isEqualsMethod((Method)method)) {
                    return proxy == args[0];
                }
                if (ReflectionUtils.isHashCodeMethod((Method)method)) {
                    return System.identityHashCode(proxy);
                }
            }
            switch (method.getName()) {
                case "unwrap": {
                    return this.connection;
                }
                case "close": {
                    return ConnectionFactoryUtils.doReleaseConnection(this.connection, this.targetConnectionFactory).doOnSubscribe(n -> {
                        this.closed = true;
                    });
                }
                case "isClosed": {
                    return this.closed;
                }
            }
            if (this.closed) {
                throw new IllegalStateException("Connection handle already closed");
            }
            if (method.getName().equals("getTargetConnection")) {
                return this.connection;
            }
            try {
                return method.invoke((Object)this.connection, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private String proxyToString(@Nullable Object proxy) {
            StringBuilder sb = new StringBuilder("Transaction-aware proxy for target Connection ");
            if (this.connection != null) {
                sb.append("[").append(this.connection.toString()).append("]");
            } else {
                sb.append(" from ConnectionFactory [").append(this.targetConnectionFactory).append("]");
            }
            return sb.toString();
        }
    }
}

