/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apiguardian.api.API;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.core.KPropertyFilterSupport;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.1.3")
public final class PropertyFilterSupport {
    public static Collection<PropertyFilter.ProjectedPath> getInputProperties(ResultProcessor resultProcessor, ProjectionFactory factory, Neo4jMappingContext mappingContext) {
        ReturnedType returnedType = resultProcessor.getReturnedType();
        Class potentiallyProjectedType = returnedType.getReturnedType();
        Class domainType = returnedType.getDomainType();
        HashSet<PropertyFilter.ProjectedPath> filteredProperties = new HashSet<PropertyFilter.ProjectedPath>();
        boolean isProjecting = returnedType.isProjecting();
        boolean isClosedProjection = factory.getProjectionInformation(potentiallyProjectedType).isClosed();
        if (!isProjecting || !isClosedProjection) {
            return Collections.emptySet();
        }
        for (String inputProperty : returnedType.getInputProperties()) {
            PropertyFilterSupport.addPropertiesFrom(domainType, potentiallyProjectedType, factory, filteredProperties, new ProjectionPathProcessor(inputProperty, PropertyPath.from((String)inputProperty, (Class)potentiallyProjectedType).getLeafProperty().getTypeInformation()), mappingContext);
        }
        for (String inputProperty : KPropertyFilterSupport.getRequiredProperties(domainType)) {
            PropertyFilterSupport.addPropertiesFrom(domainType, potentiallyProjectedType, factory, filteredProperties, new ProjectionPathProcessor(inputProperty, PropertyPath.from((String)inputProperty, (Class)domainType).getLeafProperty().getTypeInformation()), mappingContext);
        }
        return filteredProperties;
    }

    static Collection<PropertyFilter.ProjectedPath> addPropertiesFrom(Class<?> domainType, Class<?> returnType, ProjectionFactory projectionFactory, Neo4jMappingContext neo4jMappingContext) {
        ProjectionInformation projectionInformation = projectionFactory.getProjectionInformation(returnType);
        HashSet<PropertyFilter.ProjectedPath> propertyPaths = new HashSet<PropertyFilter.ProjectedPath>();
        Neo4jPersistentEntity domainEntity = (Neo4jPersistentEntity)neo4jMappingContext.getRequiredPersistentEntity(domainType);
        for (PropertyDescriptor inputProperty : projectionInformation.getInputProperties()) {
            TypeInformation typeInformation = null;
            if (projectionInformation.isClosed()) {
                typeInformation = PropertyPath.from((String)inputProperty.getName(), returnType).getTypeInformation();
            } else {
                for (GraphPropertyDescription graphProperty : domainEntity.getGraphProperties()) {
                    if (!graphProperty.getPropertyName().equals(inputProperty.getName())) continue;
                    typeInformation = ((Neo4jPersistentProperty)domainEntity.getPersistentProperty(graphProperty.getFieldName())).getTypeInformation();
                    break;
                }
                if (typeInformation == null) {
                    for (RelationshipDescription relationshipDescription : domainEntity.getRelationships()) {
                        if (!relationshipDescription.getFieldName().equals(inputProperty.getName())) continue;
                        typeInformation = ((Neo4jPersistentProperty)domainEntity.getPersistentProperty(relationshipDescription.getFieldName())).getTypeInformation();
                        break;
                    }
                }
            }
            PropertyFilterSupport.addPropertiesFrom(domainType, returnType, projectionFactory, propertyPaths, new ProjectionPathProcessor(inputProperty.getName(), typeInformation), neo4jMappingContext);
        }
        return propertyPaths;
    }

    private static void addPropertiesFrom(Class<?> domainType, Class<?> returnedType, ProjectionFactory factory, Collection<PropertyFilter.ProjectedPath> filteredProperties, ProjectionPathProcessor projectionPathProcessor, Neo4jMappingContext mappingContext) {
        ProjectionInformation projectionInformation = factory.getProjectionInformation(returnedType);
        PropertyFilter.RelaxedPropertyPath propertyPath = projectionInformation.isClosed() ? PropertyFilter.RelaxedPropertyPath.withRootType(returnedType).append(projectionPathProcessor.path) : PropertyFilter.RelaxedPropertyPath.withRootType(domainType).append(projectionPathProcessor.path);
        Class propertyType = projectionPathProcessor.typeInformation.getType();
        TypeInformation currentTypeInformation = projectionPathProcessor.typeInformation.getActualType();
        if (projectionPathProcessor.typeInformation.isMap()) {
            TypeInformation mapValueType = projectionPathProcessor.typeInformation.getRequiredMapValueType();
            if (mapValueType.isCollectionLike()) {
                currentTypeInformation = projectionPathProcessor.typeInformation.getRequiredMapValueType().getComponentType();
                propertyType = projectionPathProcessor.typeInformation.getRequiredMapValueType().getComponentType().getType();
            } else {
                currentTypeInformation = projectionPathProcessor.typeInformation.getRequiredMapValueType();
                propertyType = projectionPathProcessor.typeInformation.getRequiredMapValueType().getType();
            }
        } else if (projectionPathProcessor.typeInformation.isCollectionLike()) {
            currentTypeInformation = projectionPathProcessor.typeInformation.getComponentType();
            propertyType = projectionPathProcessor.typeInformation.getComponentType().getType();
        }
        if (mappingContext.getConversionService().isSimpleType(propertyType)) {
            filteredProperties.add(new PropertyFilter.ProjectedPath(propertyPath, false));
        } else if (mappingContext.hasPersistentEntityFor(propertyType)) {
            filteredProperties.add(new PropertyFilter.ProjectedPath(propertyPath, true));
        } else {
            ProjectionInformation nestedProjectionInformation = factory.getProjectionInformation(propertyType);
            if (nestedProjectionInformation.isClosed()) {
                filteredProperties.add(new PropertyFilter.ProjectedPath(propertyPath, false));
                for (PropertyDescriptor nestedInputProperty : nestedProjectionInformation.getInputProperties()) {
                    TypeInformation typeInformation = currentTypeInformation.getProperty(nestedInputProperty.getName());
                    ProjectionPathProcessor nextProjectionPathProcessor = projectionPathProcessor.next(nestedInputProperty, typeInformation);
                    if (!projectionPathProcessor.isChildLevel() || !domainType.equals(nextProjectionPathProcessor.typeInformation.getType()) && !returnedType.equals(nextProjectionPathProcessor.typeInformation.getActualType().getType()) && !returnedType.equals(nextProjectionPathProcessor.typeInformation.getType())) {
                        if (projectionPathProcessor.typeInformation.getActualType().getType().equals(nextProjectionPathProcessor.typeInformation.getActualType().getType()) || !projectionPathProcessor.typeInformation.isCollectionLike() && !projectionPathProcessor.typeInformation.isMap() && projectionPathProcessor.typeInformation.getType().equals(nextProjectionPathProcessor.typeInformation.getType())) {
                            filteredProperties.add(new PropertyFilter.ProjectedPath(propertyPath, true));
                            continue;
                        }
                        PropertyFilterSupport.addPropertiesFrom(domainType, returnedType, factory, filteredProperties, nextProjectionPathProcessor, mappingContext);
                        continue;
                    }
                    break;
                }
            } else {
                PropertyFilter.RelaxedPropertyPath domainBasedPropertyPath = PropertyFilter.RelaxedPropertyPath.withRootType(domainType).append(projectionPathProcessor.path);
                filteredProperties.add(new PropertyFilter.ProjectedPath(domainBasedPropertyPath, true));
            }
        }
    }

    private static class ProjectionPathProcessor {
        final TypeInformation<?> typeInformation;
        final String path;
        final String name;

        private ProjectionPathProcessor(String name, String path, @Nullable TypeInformation<?> typeInformation) {
            this.typeInformation = typeInformation;
            this.path = path;
            this.name = name;
        }

        private ProjectionPathProcessor(String name, @Nullable TypeInformation<?> typeInformation) {
            this(name, name, typeInformation);
        }

        public ProjectionPathProcessor next(PropertyDescriptor nextProperty, TypeInformation<?> nextTypeInformation) {
            String nextPropertyName = nextProperty.getName();
            return new ProjectionPathProcessor(nextPropertyName, this.path + "." + nextPropertyName, nextTypeInformation);
        }

        public boolean isChildLevel() {
            return this.path.contains(".");
        }
    }
}

