/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.function.Function;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.renderer.Dialect;

@API(status=API.Status.INTERNAL)
public final class SpringDataCypherDsl {
    public static Function<Dialect, Function<Named, FunctionInvocation>> elementIdOrIdFunction = dialect -> {
        if (dialect == Dialect.NEO4J_5) {
            return SpringDataCypherDsl::elementId;
        }
        if (dialect == Dialect.NEO4J_4) {
            return SpringDataCypherDsl::id;
        }
        return named -> {
            if (named instanceof Node) {
                Node node = (Node)named;
                return Cypher.elementId((Node)node);
            }
            if (named instanceof Relationship) {
                Relationship relationship = (Relationship)named;
                return Cypher.elementId((Relationship)relationship);
            }
            throw new IllegalArgumentException("Unsupported CypherDSL type: " + named.getClass());
        };
    };

    private SpringDataCypherDsl() {
    }

    private static FunctionInvocation id(Named expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)new ElementIdOrIdFunctionDefinition("id"), (Expression[])new Expression[]{expression.getRequiredSymbolicName()});
    }

    private static FunctionInvocation elementId(Named expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)new ElementIdOrIdFunctionDefinition("elementId"), (Expression[])new Expression[]{expression.getRequiredSymbolicName()});
    }

    private static final class ElementIdOrIdFunctionDefinition
    implements FunctionInvocation.FunctionDefinition {
        final String identifierFunction;

        private ElementIdOrIdFunctionDefinition(String identifierFunction) {
            this.identifierFunction = identifierFunction;
        }

        public String getImplementationName() {
            return this.identifierFunction;
        }

        public boolean isAggregate() {
            return false;
        }
    }
}

