/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Optional;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.springframework.data.neo4j.core.schema.GeneratedValue;
import org.springframework.data.neo4j.core.schema.IdGenerator;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.0")
public final class IdDescription {
    @Nullable
    private final Class<? extends IdGenerator<?>> idGeneratorClass;
    @Nullable
    private final String idGeneratorRef;
    @Nullable
    private final String graphPropertyName;
    private final boolean isDeprecated;
    private final Lazy<Expression> idExpression;

    public static IdDescription forAssignedIds(SymbolicName symbolicName, String graphPropertyName) {
        Assert.notNull((Object)graphPropertyName, (String)"Graph property name is required");
        return new IdDescription(symbolicName, null, null, graphPropertyName, false);
    }

    public static IdDescription forInternallyGeneratedIds(SymbolicName symbolicName) {
        return IdDescription.forInternallyGeneratedIds(symbolicName, false);
    }

    public static IdDescription forInternallyGeneratedIds(SymbolicName symbolicName, boolean isDeprecated) {
        return new IdDescription(symbolicName, GeneratedValue.InternalIdGenerator.class, null, null, isDeprecated);
    }

    public static IdDescription forExternallyGeneratedIds(SymbolicName symbolicName, @Nullable Class<? extends IdGenerator<?>> idGeneratorClass, @Nullable String idGeneratorRef, String graphPropertyName) {
        Assert.notNull((Object)graphPropertyName, (String)"Graph property name is required");
        try {
            Assert.hasText((String)idGeneratorRef, (String)"Reference to an ID generator has precedence");
            return new IdDescription(symbolicName, null, idGeneratorRef, graphPropertyName, false);
        }
        catch (IllegalArgumentException e) {
            Assert.notNull(idGeneratorClass, (String)"Class of id generator is required");
            Assert.isTrue((idGeneratorClass != GeneratedValue.InternalIdGenerator.class ? 1 : 0) != 0, (String)"Cannot use InternalIdGenerator for externally generated ids");
            return new IdDescription(symbolicName, idGeneratorClass, null, graphPropertyName, false);
        }
    }

    private IdDescription(SymbolicName symbolicName, @Nullable Class<? extends IdGenerator<?>> idGeneratorClass, @Nullable String idGeneratorRef, @Nullable String graphPropertyName, boolean isDeprecated) {
        this.idGeneratorClass = idGeneratorClass;
        this.idGeneratorRef = idGeneratorRef != null && idGeneratorRef.isEmpty() ? null : idGeneratorRef;
        this.graphPropertyName = graphPropertyName;
        this.isDeprecated = isDeprecated;
        this.idExpression = Lazy.of(() -> {
            Node rootNode = Cypher.anyNode((SymbolicName)symbolicName);
            if (this.isInternallyGeneratedId()) {
                return isDeprecated ? rootNode.internalId() : rootNode.elementId();
            }
            return (Expression)this.getOptionalGraphPropertyName().map(propertyName -> Cypher.property((Expression)symbolicName, (String[])new String[]{propertyName})).get();
        });
    }

    public Expression asIdExpression() {
        return (Expression)this.idExpression.get();
    }

    public Expression asIdExpression(String nodeName) {
        Node rootNode = Cypher.anyNode((String)nodeName);
        if (this.isInternallyGeneratedId()) {
            return this.isDeprecated ? rootNode.internalId() : rootNode.elementId();
        }
        return (Expression)this.getOptionalGraphPropertyName().map(propertyName -> Cypher.property((String)nodeName, (String[])new String[]{propertyName})).get();
    }

    public Optional<Class<? extends IdGenerator<?>>> getIdGeneratorClass() {
        return Optional.ofNullable(this.idGeneratorClass);
    }

    public Optional<String> getIdGeneratorRef() {
        return Optional.ofNullable(this.idGeneratorRef);
    }

    public boolean isAssignedId() {
        return this.idGeneratorClass == null && this.idGeneratorRef == null;
    }

    public boolean isInternallyGeneratedId() {
        return this.idGeneratorClass == GeneratedValue.InternalIdGenerator.class;
    }

    public boolean isExternallyGeneratedId() {
        return this.idGeneratorClass != null && this.idGeneratorClass != GeneratedValue.InternalIdGenerator.class || this.idGeneratorRef != null;
    }

    public Optional<String> getOptionalGraphPropertyName() {
        return Optional.ofNullable(this.graphPropertyName);
    }
}

