/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.cypherdsl.core.Statement;
import org.springframework.data.neo4j.core.FluentFindOperation;
import org.springframework.data.neo4j.core.FluentSaveOperation;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.TemplateSupport;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.util.Assert;

final class FluentOperationSupport
implements FluentFindOperation,
FluentSaveOperation {
    private final Neo4jTemplate template;

    FluentOperationSupport(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public <T> FluentFindOperation.ExecutableFind<T> find(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableFindSupport<T>(this.template, domainType, domainType, null, Collections.emptyMap());
    }

    @Override
    public <T> FluentSaveOperation.ExecutableSave<T> save(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableSaveSupport<T>(this.template, domainType);
    }

    private static class ExecutableFindSupport<T>
    implements FluentFindOperation.ExecutableFind<T>,
    FluentFindOperation.FindWithProjection<T>,
    FluentFindOperation.FindWithQuery<T>,
    FluentFindOperation.TerminatingFind<T> {
        private final Neo4jTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final String query;
        private final Map<String, Object> parameters;
        private final QueryFragmentsAndParameters queryFragmentsAndParameters;

        ExecutableFindSupport(Neo4jTemplate template, Class<?> domainType, Class<T> returnType, String query, Map<String, Object> parameters) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query;
            this.parameters = parameters;
            this.queryFragmentsAndParameters = null;
        }

        ExecutableFindSupport(Neo4jTemplate template, Class<?> domainType, Class<T> returnType, QueryFragmentsAndParameters queryFragmentsAndParameters) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = null;
            this.parameters = null;
            this.queryFragmentsAndParameters = queryFragmentsAndParameters;
        }

        @Override
        public <T1> FluentFindOperation.FindWithQuery<T1> as(Class<T1> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null");
            return new ExecutableFindSupport<T1>(this.template, this.domainType, returnType, this.query, this.parameters);
        }

        @Override
        public FluentFindOperation.TerminatingFind<T> matching(String query, Map<String, Object> parameters) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            return new ExecutableFindSupport<T>(this.template, this.domainType, this.returnType, query, parameters);
        }

        @Override
        public FluentFindOperation.TerminatingFind<T> matching(QueryFragmentsAndParameters queryFragmentsAndParameters) {
            Assert.notNull((Object)queryFragmentsAndParameters, (String)"Query fragments must not be null");
            return new ExecutableFindSupport<T>(this.template, this.domainType, this.returnType, queryFragmentsAndParameters);
        }

        @Override
        public FluentFindOperation.TerminatingFind<T> matching(Statement statement, Map<String, Object> parameter) {
            return this.matching(this.template.render(statement), TemplateSupport.mergeParameters(statement, parameter));
        }

        @Override
        public T oneValue() {
            List<T> result = this.doFind(TemplateSupport.FetchType.ONE);
            if (result.isEmpty()) {
                return null;
            }
            return result.iterator().next();
        }

        @Override
        public List<T> all() {
            return this.doFind(TemplateSupport.FetchType.ALL);
        }

        private List<T> doFind(TemplateSupport.FetchType fetchType) {
            return this.template.doFind(this.query, this.parameters, this.domainType, this.returnType, fetchType, this.queryFragmentsAndParameters);
        }
    }

    private static class ExecutableSaveSupport<DT>
    implements FluentSaveOperation.ExecutableSave<DT> {
        private final Neo4jTemplate template;
        private final Class<DT> domainType;

        ExecutableSaveSupport(Neo4jTemplate template, Class<DT> domainType) {
            this.template = template;
            this.domainType = domainType;
        }

        @Override
        public <T> T one(T instance) {
            List<T> result = this.doSave(Collections.singleton(instance));
            if (result.isEmpty()) {
                return null;
            }
            return result.get(0);
        }

        @Override
        public <T> List<T> all(Iterable<T> instances) {
            return this.doSave(instances);
        }

        private <T> List<T> doSave(Iterable<T> instances) {
            return this.template.doSave(instances, this.domainType);
        }
    }
}

