/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.IdDescription;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.lang.Nullable;

@API(status=API.Status.STABLE, since="6.0")
public interface NodeDescription<T> {
    public String getPrimaryLabel();

    public String getMostAbstractParentLabel(NodeDescription<?> var1);

    public List<String> getAdditionalLabels();

    default public List<String> getStaticLabels() {
        ArrayList<String> staticLabels = new ArrayList<String>();
        staticLabels.add(this.getPrimaryLabel());
        staticLabels.addAll(this.getAdditionalLabels());
        return staticLabels;
    }

    public Class<T> getUnderlyingClass();

    @Nullable
    public IdDescription getIdDescription();

    public Collection<GraphPropertyDescription> getGraphProperties();

    public Collection<GraphPropertyDescription> getGraphPropertiesInHierarchy();

    public Optional<GraphPropertyDescription> getGraphProperty(String var1);

    default public boolean isUsingInternalIds() {
        return this.getIdDescription() != null && this.getIdDescription().isInternallyGeneratedId();
    }

    public Collection<RelationshipDescription> getRelationships();

    public Collection<RelationshipDescription> getRelationshipsInHierarchy(Predicate<PropertyFilter.RelaxedPropertyPath> var1);

    public void addChildNodeDescription(NodeDescription<?> var1);

    public Collection<NodeDescription<?>> getChildNodeDescriptionsInHierarchy();

    public void setParentNodeDescription(NodeDescription<?> var1);

    @Nullable
    public NodeDescription<?> getParentNodeDescription();

    default public Expression getIdExpression() {
        if (this.getIdDescription().getOptionalGraphPropertyName().flatMap(this::getGraphProperty).filter(GraphPropertyDescription::isComposite).isPresent()) {
            throw new IllegalStateException("A composite id property cannot be used as ID expression.");
        }
        return this.getIdDescription().asIdExpression();
    }

    public boolean containsPossibleCircles(Predicate<PropertyFilter.RelaxedPropertyPath> var1);

    public boolean describesInterface();
}

