/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import java.util.Collection;
import java.util.Collections;
import org.neo4j.driver.Bookmark;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.UserSelection;

final class Neo4jTransactionContext {
    private final DatabaseSelection databaseSelection;
    private final UserSelection userSelection;
    private final Collection<Bookmark> bookmarks;

    Neo4jTransactionContext(DatabaseSelection databaseSelection, UserSelection userSelection) {
        this(databaseSelection, userSelection, Collections.emptyList());
    }

    Neo4jTransactionContext(DatabaseSelection databaseSelection, UserSelection userSelection, Collection<Bookmark> bookmarks) {
        this.databaseSelection = databaseSelection;
        this.userSelection = userSelection;
        this.bookmarks = bookmarks;
    }

    DatabaseSelection getDatabaseSelection() {
        return this.databaseSelection;
    }

    UserSelection getUserSelection() {
        return this.userSelection;
    }

    Collection<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    boolean isForDatabaseAndUser(DatabaseSelection inDatabase, UserSelection asUser) {
        return this.databaseSelection.equals(inDatabase) && this.userSelection.equals(asUser);
    }
}

