/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.SpelExpressionTransformer;
import org.springframework.util.Assert;

abstract class DocumentEnhancingOperation
implements FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation {
    private final Map<Object, Object> valueMap;
    private ExposedFields exposedFields = ExposedFields.empty();

    protected DocumentEnhancingOperation(Map<Object, Object> source) {
        this.valueMap = new LinkedHashMap<Object, Object>(source);
        for (Object key : source.keySet()) {
            this.exposedFields = this.add(key);
        }
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        AggregationOperationContext operationContext = context.inheritAndExpose(this.exposedFields);
        if (this.valueMap.size() == 1) {
            return context.getMappedObject(new Document(this.mongoOperator(), (Object)DocumentEnhancingOperation.toSetEntry(this.valueMap.entrySet().iterator().next(), operationContext)));
        }
        Document $set = new Document();
        this.valueMap.entrySet().stream().map(it -> DocumentEnhancingOperation.toSetEntry(it, operationContext)).forEach(arg_0 -> ((Document)$set).putAll(arg_0));
        return context.getMappedObject(new Document(this.mongoOperator(), (Object)$set));
    }

    protected abstract String mongoOperator();

    @Override
    public String getOperator() {
        return this.mongoOperator();
    }

    protected Map<Object, Object> getValueMap() {
        return this.valueMap;
    }

    @Override
    public ExposedFields getFields() {
        return this.exposedFields;
    }

    private ExposedFields add(Object fieldValue) {
        if (fieldValue instanceof Field) {
            Field field = (Field)fieldValue;
            return this.exposedFields.and(new ExposedFields.ExposedField(field, true));
        }
        if (fieldValue instanceof String) {
            String fieldName = (String)fieldValue;
            return this.exposedFields.and(new ExposedFields.ExposedField(Fields.field(fieldName), true));
        }
        throw new IllegalArgumentException(String.format("Expected %s to be a field/property", fieldValue));
    }

    private static Document toSetEntry(Map.Entry<Object, Object> entry, AggregationOperationContext context) {
        String string;
        Object object = entry.getKey();
        if (object instanceof String) {
            String key = (String)object;
            string = context.getReference(key).getRaw();
        } else {
            string = context.getReference((Field)entry.getKey()).getRaw();
        }
        String field = string;
        Object value = DocumentEnhancingOperation.computeValue(entry.getValue(), context);
        return new Document(field, value);
    }

    private static @Nullable Object computeValue(@Nullable Object value, AggregationOperationContext context) {
        if (value == null) {
            return value;
        }
        if (value instanceof Field) {
            Field field = (Field)value;
            return context.getReference(field).toString();
        }
        if (value instanceof ExpressionProjection) {
            ExpressionProjection expressionProjection = (ExpressionProjection)value;
            return expressionProjection.toExpression(context);
        }
        if (value instanceof AggregationExpression) {
            AggregationExpression aggregationExpression = (AggregationExpression)value;
            return aggregationExpression.toDocument(context);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.stream().map(it -> DocumentEnhancingOperation.computeValue(it, context)).collect(Collectors.toList());
        }
        return value;
    }

    static class ExpressionProjection {
        private static final SpelExpressionTransformer TRANSFORMER = new SpelExpressionTransformer();
        private final String expression;
        private final Object[] params;

        ExpressionProjection(String expression, Object[] parameters) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            Assert.notNull((Object)parameters, (String)"Parameters must not be null");
            this.expression = expression;
            this.params = (Object[])parameters.clone();
        }

        @Nullable Object toExpression(AggregationOperationContext context) {
            return TRANSFORMER.transform(this.expression, context, this.params);
        }
    }
}

