/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util;

import java.time.Duration;
import java.util.function.Supplier;
import org.springframework.core.env.Environment;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.format.datetime.standard.DurationFormatterUtils;

public class DurationUtil {
    private static final ValueExpressionParser PARSER = ValueExpressionParser.create(SpelExpressionParser::new);

    public static Duration evaluate(String value, ValueEvaluationContext evaluationContext) {
        ValueExpression expression = PARSER.parse(value);
        Object evaluatedTimeout = expression.evaluate(evaluationContext);
        if (evaluatedTimeout == null) {
            return Duration.ZERO;
        }
        if (evaluatedTimeout instanceof Duration) {
            Duration duration = (Duration)evaluatedTimeout;
            return duration;
        }
        return DurationUtil.parse(evaluatedTimeout.toString());
    }

    public static Duration evaluate(String value, final Supplier<EvaluationContext> evaluationContext) {
        return DurationUtil.evaluate(value, new ValueEvaluationContext(){

            public Environment getEnvironment() {
                throw new IllegalStateException();
            }

            public EvaluationContext getEvaluationContext() {
                return (EvaluationContext)evaluationContext.get();
            }
        });
    }

    public static Duration parse(String duration) {
        return DurationFormatterUtils.detectAndParse((String)duration);
    }
}

