/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;

class StringAggregationOperation
implements AggregationOperation {
    private static final Pattern OPERATOR_PATTERN = Pattern.compile("\\$\\w+");
    private final String source;
    private final Class<?> domainType;
    private final Function<String, Document> bindFunction;
    private final @Nullable String operator;

    StringAggregationOperation(String source, Class<?> domainType, Function<String, Document> bindFunction) {
        this.source = source;
        this.domainType = domainType;
        this.bindFunction = bindFunction;
        Matcher matcher = OPERATOR_PATTERN.matcher(source);
        this.operator = matcher.find() ? matcher.group() : null;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return context.getMappedObject(this.bindFunction.apply(this.source), this.domainType);
    }

    @Override
    public String getOperator() {
        return this.operator != null ? this.operator : AggregationOperation.super.getOperator();
    }
}

