/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.core.ReactiveWrappers;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.annotation.Collation;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.DiskUse;
import org.springframework.data.mongodb.core.query.Meta;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.Aggregation;
import org.springframework.data.mongodb.repository.Hint;
import org.springframework.data.mongodb.repository.Meta;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.mongodb.repository.ReadPreference;
import org.springframework.data.mongodb.repository.Tailable;
import org.springframework.data.mongodb.repository.Update;
import org.springframework.data.mongodb.repository.VectorSearch;
import org.springframework.data.mongodb.repository.query.MongoEntityMetadata;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.repository.query.QueryUtils;
import org.springframework.data.mongodb.repository.query.SimpleMongoEntityMetadata;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MongoQueryMethod
extends QueryMethod {
    private final Method method;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final Map<Class<? extends Annotation>, Optional<Annotation>> annotationCache;
    private @Nullable MongoEntityMetadata<?> metadata;
    private final Lazy<Boolean> isModifying = Lazy.of(this::resolveModifyingQueryIndicators);

    public MongoQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this(method, metadata, projectionFactory, mappingContext, MongoParameters::new);
    }

    MongoQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, Function<ParametersSource, ? extends MongoParameters> parametersFunction) {
        super(method, metadata, projectionFactory, parametersFunction);
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        this.method = method;
        this.mappingContext = mappingContext;
        this.annotationCache = new ConcurrentReferenceHashMap();
    }

    public boolean hasAnnotatedQuery() {
        return this.findAnnotatedQuery().isPresent();
    }

    public @Nullable String getAnnotatedQuery() {
        return this.findAnnotatedQuery().orElse(null);
    }

    private Optional<String> findAnnotatedQuery() {
        return this.lookupQueryAnnotation().map(Query::value).filter(StringUtils::hasText);
    }

    @Nullable String getFieldSpecification() {
        return this.lookupQueryAnnotation().map(Query::fields).filter(StringUtils::hasText).orElse(null);
    }

    public MongoEntityMetadata<?> getEntityInformation() {
        if (this.metadata == null) {
            Class returnedObjectType = this.getReturnedObjectType();
            Class<?> domainClass = this.getDomainClass();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedObjectType)) {
                this.metadata = new SimpleMongoEntityMetadata(domainClass, (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass));
            } else {
                MongoPersistentEntity returnedEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(returnedObjectType);
                MongoPersistentEntity managedEntity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
                returnedEntity = returnedEntity == null || returnedEntity.getType().isInterface() ? managedEntity : returnedEntity;
                MongoPersistentEntity collectionEntity = domainClass.isAssignableFrom(returnedObjectType) ? returnedEntity : managedEntity;
                this.metadata = new SimpleMongoEntityMetadata(returnedEntity.getType(), collectionEntity);
            }
        }
        return this.metadata;
    }

    protected Class<?> getDomainClass() {
        return super.getDomainClass();
    }

    public MongoParameters getParameters() {
        return (MongoParameters)super.getParameters();
    }

    public boolean isGeoNearQuery() {
        return MongoParameters.isGeoNearQuery(this.method);
    }

    @Nullable Query getQueryAnnotation() {
        return this.lookupQueryAnnotation().orElse(null);
    }

    Optional<Query> lookupQueryAnnotation() {
        return this.doFindAnnotation(Query.class);
    }

    public TypeInformation<?> getReturnType() {
        return TypeInformation.fromReturnTypeOf((Method)this.method);
    }

    public boolean hasQueryMetaAttributes() {
        return this.getMetaAnnotation() != null;
    }

    @Nullable Meta getMetaAnnotation() {
        return this.doFindAnnotation(Meta.class).orElse(null);
    }

    @Nullable Tailable getTailableAnnotation() {
        return this.doFindAnnotation(Tailable.class).orElse(null);
    }

    public org.springframework.data.mongodb.core.query.Meta getQueryMetaAttributes() {
        DiskUse diskUse;
        Meta meta = this.getMetaAnnotation();
        if (meta == null) {
            return new org.springframework.data.mongodb.core.query.Meta();
        }
        org.springframework.data.mongodb.core.query.Meta metaAttributes = new org.springframework.data.mongodb.core.query.Meta();
        if (meta.maxExecutionTimeMs() > 0L) {
            metaAttributes.setMaxTimeMsec(meta.maxExecutionTimeMs());
        }
        if (meta.cursorBatchSize() != 0) {
            metaAttributes.setCursorBatchSize(meta.cursorBatchSize());
        }
        if (StringUtils.hasText((String)meta.comment())) {
            metaAttributes.setComment(meta.comment());
        }
        if (!ObjectUtils.isEmpty((Object[])meta.flags())) {
            for (Meta.CursorOption option : meta.flags()) {
                metaAttributes.addFlag(option);
            }
        }
        if (!(diskUse = DiskUse.of(meta.allowDiskUse())).equals((Object)DiskUse.DEFAULT)) {
            metaAttributes.setAllowDiskUse(diskUse.equals((Object)DiskUse.ALLOW));
        }
        return metaAttributes;
    }

    public boolean hasAnnotatedSort() {
        return this.lookupQueryAnnotation().map(Query::sort).filter(StringUtils::hasText).isPresent();
    }

    public String getAnnotatedSort() {
        return this.lookupQueryAnnotation().map(Query::sort).orElseThrow(() -> new IllegalStateException("Expected to find @Query annotation but did not; Make sure to check hasAnnotatedSort() before."));
    }

    public boolean hasAnnotatedReadPreference() {
        return this.doFindReadPreferenceAnnotation().map(ReadPreference::value).filter(StringUtils::hasText).isPresent();
    }

    public String getAnnotatedReadPreference() {
        return this.doFindReadPreferenceAnnotation().map(ReadPreference::value).orElseThrow(() -> new IllegalStateException("Expected to find @ReadPreference annotation but did not; Make sure to check hasAnnotatedReadPreference() before."));
    }

    private Optional<ReadPreference> doFindReadPreferenceAnnotation() {
        return this.doFindAnnotation(ReadPreference.class).or(() -> this.doFindAnnotationInClass(ReadPreference.class));
    }

    public boolean hasAnnotatedCollation() {
        return this.doFindAnnotation(Collation.class).map(Collation::value).filter(StringUtils::hasText).isPresent();
    }

    public String getAnnotatedCollation() {
        return this.doFindAnnotation(Collation.class).map(Collation::value).orElseThrow(() -> new IllegalStateException("Expected to find @Collation annotation but did not; Make sure to check hasAnnotatedCollation() before."));
    }

    public boolean hasAnnotatedAggregation() {
        return this.findAnnotatedAggregation().isPresent();
    }

    public String[] getAnnotatedAggregation() {
        return this.findAnnotatedAggregation().orElseThrow(() -> new IllegalStateException("Expected to find @Aggregation annotation but did not; Make sure to check hasAnnotatedAggregation() before."));
    }

    public boolean hasAnnotatedHint() {
        return this.doFindAnnotation(Hint.class).map(Hint::indexName).filter(StringUtils::hasText).isPresent();
    }

    public String getAnnotatedHint() {
        return this.doFindAnnotation(Hint.class).map(Hint::indexName).orElseThrow(() -> new IllegalStateException("Expected to find @Hint annotation but did not; Make sure to check hasAnnotatedHint() before."));
    }

    private Optional<String[]> findAnnotatedAggregation() {
        return this.lookupAggregationAnnotation().map(Aggregation::pipeline).filter(it -> !ObjectUtils.isEmpty((Object[])it));
    }

    public boolean hasAnnotatedVectorSearch() {
        return this.findAnnotatedVectorSearch().isPresent();
    }

    public VectorSearch getRequiredVectorSearchAnnotation() {
        return this.doFindAnnotation(VectorSearch.class).orElseThrow(() -> new IllegalStateException("Method is not annotated with @VectorSearch"));
    }

    Optional<VectorSearch> findAnnotatedVectorSearch() {
        return this.lookupVectorSearchAnnotation();
    }

    Optional<Aggregation> lookupAggregationAnnotation() {
        return this.doFindAnnotation(Aggregation.class);
    }

    Optional<VectorSearch> lookupVectorSearchAnnotation() {
        return this.doFindAnnotation(VectorSearch.class);
    }

    Optional<Update> lookupUpdateAnnotation() {
        return this.doFindAnnotation(Update.class);
    }

    private <A extends Annotation> Optional<A> doFindAnnotation(Class<A> annotationType) {
        return this.annotationCache.computeIfAbsent(annotationType, it -> Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, (Class)it)));
    }

    private <A extends Annotation> Optional<A> doFindAnnotationInClass(Class<A> annotationType) {
        Optional<Annotation> mergedAnnotation = Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation(this.method.getDeclaringClass(), annotationType));
        this.annotationCache.put(annotationType, mergedAnnotation);
        return mergedAnnotation;
    }

    public boolean isModifyingQuery() {
        return (Boolean)this.isModifying.get();
    }

    private boolean resolveModifyingQueryIndicators() {
        return this.hasAnnotatedUpdate() || QueryUtils.indexOfAssignableParameter(UpdateDefinition.class, this.method.getParameterTypes()) != -1;
    }

    public boolean hasAnnotatedUpdate() {
        return this.lookupUpdateAnnotation().isPresent();
    }

    public @Nullable Update getUpdateSource() {
        return this.lookupUpdateAnnotation().orElse(null);
    }

    public void verify() {
        if (this.isModifyingQuery()) {
            if (this.isCollectionQuery() || this.isScrollQuery() || this.isSliceQuery() || this.isPageQuery() || this.isGeoNearQuery() || !this.isNumericOrVoidReturnValue()) {
                throw new IllegalStateException(String.format("Update method may be void or return a numeric value (the number of updated documents). Offending Method: %s.%s", ClassUtils.getShortName(this.method.getDeclaringClass()), this.method.getName()));
            }
            if (this.hasAnnotatedUpdate() && !StringUtils.hasText((String)this.getUpdateSource().update()) && ObjectUtils.isEmpty((Object[])this.getUpdateSource().pipeline())) {
                throw new IllegalStateException(String.format("Update method must define either 'Update#update' or 'Update#pipeline' attribute; Offending Method: %s.%s", ClassUtils.getShortName(this.method.getDeclaringClass()), this.method.getName()));
            }
        }
        if (this.hasAnnotatedAggregation()) {
            for (String stage : this.getAnnotatedAggregation()) {
                if (!BsonUtils.isJsonArray(stage)) continue;
                throw new IllegalStateException(String.format("Invalid aggregation pipeline. Please split the definition from @Aggregation(\"[{...}, {...}]\") to @Aggregation({ \"{...}\", \"{...}\" }).\nOffending Method: %s.%s\n", ClassUtils.getShortName(this.method.getDeclaringClass()), this.method.getName()));
            }
        }
    }

    private boolean isNumericOrVoidReturnValue() {
        Class resultType = this.getReturnedObjectType();
        if (ReactiveWrappers.usesReactiveType((Class)resultType)) {
            resultType = this.getReturnType().getComponentType().getType();
        }
        boolean isUpdateCountReturnType = ClassUtils.isAssignable(Number.class, (Class)resultType);
        boolean isVoidReturnType = ReflectionUtils.isVoid((Class)resultType);
        return isUpdateCountReturnType || isVoidReturnType;
    }
}

