/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.jspecify.annotations.Nullable;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.util.Assert;

public class MetricConversion {
    private static final BigDecimal METERS_MULTIPLIER = new BigDecimal(Metrics.KILOMETERS.getMultiplier()).multiply(new BigDecimal(1000));
    private static final int PRECISION = 8;

    public static double getMetersToMetricMultiplier(Metric metric) {
        ConversionMultiplier conversionMultiplier = ConversionMultiplier.builder().from(METERS_MULTIPLIER).to(metric).build();
        return conversionMultiplier.multiplier().doubleValue();
    }

    public static double getDistanceInMeters(Distance distance) {
        return new BigDecimal(distance.getValue()).multiply(MetricConversion.getMetricToMetersMultiplier(distance.getMetric())).doubleValue();
    }

    public static double toRadians(Distance distance) {
        return MetricConversion.metersToRadians(MetricConversion.getDistanceInMeters(distance));
    }

    public static double metersToRadians(double meters) {
        return BigDecimal.valueOf(meters).divide(METERS_MULTIPLIER, MathContext.DECIMAL64).doubleValue();
    }

    private static BigDecimal getMetricToMetersMultiplier(Metric metric) {
        ConversionMultiplier conversionMultiplier = ConversionMultiplier.builder().from(metric).to(METERS_MULTIPLIER).build();
        return conversionMultiplier.multiplier();
    }

    private static class ConversionMultiplier {
        private final BigDecimal source;
        private final BigDecimal target;

        ConversionMultiplier(Number source, Number target) {
            BigDecimal bigDecimal;
            this.source = source instanceof BigDecimal ? (bigDecimal = (BigDecimal)source) : BigDecimal.valueOf(source.doubleValue());
            this.target = target instanceof BigDecimal ? (bigDecimal = (BigDecimal)target) : BigDecimal.valueOf(target.doubleValue());
        }

        BigDecimal multiplier() {
            return this.target.divide(this.source, 8, RoundingMode.HALF_UP);
        }

        static ConversionMultiplierBuilder builder() {
            return new ConversionMultiplierBuilder();
        }
    }

    private static class ConversionMultiplierBuilder {
        private @Nullable Number from;
        private @Nullable Number to;

        ConversionMultiplierBuilder() {
        }

        ConversionMultiplierBuilder from(Number from) {
            this.from = from;
            return this;
        }

        ConversionMultiplierBuilder from(Metric from) {
            this.from = from.getMultiplier();
            return this;
        }

        ConversionMultiplierBuilder to(Number to) {
            this.to = to;
            return this;
        }

        ConversionMultiplierBuilder to(Metric to) {
            this.to = to.getMultiplier();
            return this;
        }

        ConversionMultiplier build() {
            Assert.notNull((Object)this.from, (String)"[From] must be set first");
            Assert.notNull((Object)this.to, (String)"[To] must be set first");
            return new ConversionMultiplier(this.from, this.to);
        }
    }
}

