/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import java.util.Optional;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.messaging.MessageListener;
import org.springframework.data.mongodb.core.messaging.SubscriptionRequest;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class TailableCursorRequest<T>
implements SubscriptionRequest<Document, T, SubscriptionRequest.RequestOptions> {
    private final MessageListener<Document, ? super T> messageListener;
    private final TailableCursorRequestOptions options;

    public TailableCursorRequest(MessageListener<Document, ? super T> messageListener, SubscriptionRequest.RequestOptions options) {
        TailableCursorRequestOptions tailableCursorRequestOptions;
        Assert.notNull(messageListener, (String)"MessageListener must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        this.messageListener = messageListener;
        this.options = options instanceof TailableCursorRequestOptions ? (tailableCursorRequestOptions = (TailableCursorRequestOptions)options) : TailableCursorRequestOptions.of(options);
    }

    @Override
    public MessageListener<Document, ? super T> getMessageListener() {
        return this.messageListener;
    }

    @Override
    public TailableCursorRequestOptions getRequestOptions() {
        return this.options;
    }

    public static TailableCursorRequestBuilder builder() {
        return new TailableCursorRequestBuilder();
    }

    public static <T> TailableCursorRequestBuilder<T> builder(MessageListener<Document, ? super T> listener) {
        TailableCursorRequestBuilder<? super T> builder = new TailableCursorRequestBuilder<T>();
        return builder.publishTo(listener);
    }

    public static class TailableCursorRequestOptions
    implements SubscriptionRequest.RequestOptions {
        private @Nullable String collectionName;
        private @Nullable Query query;

        TailableCursorRequestOptions() {
        }

        public static TailableCursorRequestOptions of(SubscriptionRequest.RequestOptions options) {
            return TailableCursorRequestOptions.builder().collection(options.getCollectionName()).build();
        }

        public static TailableCursorRequestOptionsBuilder builder() {
            return new TailableCursorRequestOptionsBuilder();
        }

        @Override
        public @Nullable String getCollectionName() {
            return this.collectionName;
        }

        public Optional<Query> getQuery() {
            return Optional.ofNullable(this.query);
        }

        public static class TailableCursorRequestOptionsBuilder {
            private @Nullable String collectionName;
            private @Nullable Query query;

            private TailableCursorRequestOptionsBuilder() {
            }

            @Contract(value="_ -> this")
            public TailableCursorRequestOptionsBuilder collection(String collection) {
                Assert.hasText((String)collection, (String)"Collection must not be null nor empty");
                this.collectionName = collection;
                return this;
            }

            @Contract(value="_ -> this")
            public TailableCursorRequestOptionsBuilder filter(Query filter) {
                Assert.notNull((Object)filter, (String)"Filter must not be null");
                this.query = filter;
                return this;
            }

            @Contract(value="-> new")
            public TailableCursorRequestOptions build() {
                TailableCursorRequestOptions options = new TailableCursorRequestOptions();
                options.collectionName = this.collectionName;
                options.query = this.query;
                return options;
            }
        }
    }

    public static class TailableCursorRequestBuilder<T> {
        private @Nullable MessageListener<Document, ? super T> listener;
        private TailableCursorRequestOptions.TailableCursorRequestOptionsBuilder delegate = TailableCursorRequestOptions.builder();

        private TailableCursorRequestBuilder() {
        }

        @Contract(value="_ -> this")
        public TailableCursorRequestBuilder<T> collection(String collectionName) {
            Assert.hasText((String)collectionName, (String)"CollectionName must not be null");
            this.delegate.collection(collectionName);
            return this;
        }

        @Contract(value="_ -> this")
        public TailableCursorRequestBuilder<T> publishTo(MessageListener<Document, ? super T> messageListener) {
            Assert.notNull(messageListener, (String)"MessageListener must not be null");
            this.listener = messageListener;
            return this;
        }

        @Contract(value="_ -> this")
        public TailableCursorRequestBuilder<T> filter(Query filter) {
            Assert.notNull((Object)filter, (String)"Filter must not be null");
            this.delegate.filter(filter);
            return this;
        }

        @Contract(value="_ -> new")
        public TailableCursorRequest<T> build() {
            Assert.notNull(this.listener, (String)"MessageListener must not be null");
            return new TailableCursorRequest<T>(this.listener, this.delegate.build());
        }
    }
}

