/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.messaging.MessageListener;
import org.springframework.util.Assert;

public interface SubscriptionRequest<S, T, O extends RequestOptions> {
    public MessageListener<S, ? super T> getMessageListener();

    public O getRequestOptions();

    public static interface RequestOptions {
        default public @Nullable String getDatabaseName() {
            return null;
        }

        public @Nullable String getCollectionName();

        default public Duration maxAwaitTime() {
            return Duration.ZERO;
        }

        public static RequestOptions none() {
            return () -> null;
        }

        public static RequestOptions justDatabase(final String database) {
            Assert.notNull((Object)database, (String)"Database must not be null");
            return new RequestOptions(){

                @Override
                public @Nullable String getCollectionName() {
                    return null;
                }

                @Override
                public String getDatabaseName() {
                    return database;
                }
            };
        }

        public static RequestOptions justCollection(String collection) {
            Assert.notNull((Object)collection, (String)"Collection must not be null");
            return () -> collection;
        }

        public static RequestOptions of(final String database, final String collection) {
            Assert.notNull((Object)database, (String)"Database must not be null");
            Assert.notNull((Object)collection, (String)"Collection must not be null");
            return new RequestOptions(){

                @Override
                public String getCollectionName() {
                    return collection;
                }

                @Override
                public String getDatabaseName() {
                    return database;
                }
            };
        }
    }
}

