/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.mapping.FieldType;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class MongoField {
    private final FieldName name;
    private final FieldType fieldType;
    private final int order;

    protected MongoField(FieldName name, Class<?> targetFieldType, int fieldOrder) {
        this(name, FieldType.valueOf(targetFieldType.getSimpleName()), fieldOrder);
    }

    protected MongoField(FieldName name, FieldType fieldType, int fieldOrder) {
        this.name = name;
        this.fieldType = fieldType;
        this.order = fieldOrder;
    }

    public static MongoField fromKey(String name) {
        return MongoField.builder().name(name).build();
    }

    public static MongoField fromPath(String name) {
        return MongoField.builder().path(name).build();
    }

    public static MongoFieldBuilder builder() {
        return new MongoFieldBuilder();
    }

    public FieldName getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    MongoField withPrefix(String prefix) {
        return new MongoField(new FieldName(prefix + this.name.name(), this.name.type()), this.fieldType, this.order);
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoField that = (MongoField)o;
        if (this.order != that.order) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.name, (Object)that.name)) {
            return false;
        }
        return this.fieldType == that.fieldType;
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.name);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)((Object)this.fieldType));
        result = 31 * result + this.order;
        return result;
    }

    public String toString() {
        return this.name.toString();
    }

    public static class MongoFieldBuilder {
        private @Nullable String name;
        private FieldName.Type nameType = FieldName.Type.PATH;
        private FieldType type = FieldType.IMPLICIT;
        private int order = Integer.MAX_VALUE;

        @Contract(value="_ -> this")
        public MongoFieldBuilder fieldType(FieldType fieldType) {
            this.type = fieldType;
            return this;
        }

        @Contract(value="_ -> this")
        public MongoFieldBuilder name(String fieldName) {
            Assert.hasText((String)fieldName, (String)"Field name must not be empty");
            this.name = fieldName;
            this.nameType = FieldName.Type.KEY;
            return this;
        }

        @Contract(value="_ -> this")
        public MongoFieldBuilder path(String path) {
            Assert.hasText((String)path, (String)"Field path (name) must not be empty");
            this.name = path;
            this.nameType = FieldName.Type.PATH;
            return this;
        }

        @Contract(value="_ -> this")
        public MongoFieldBuilder order(int order) {
            this.order = order;
            return this;
        }

        @Contract(value="-> new")
        public MongoField build() {
            Assert.notNull((Object)this.name, (String)"Name of Field must not be null");
            return new MongoField(new FieldName(this.name, this.nameType), this.type, this.order);
        }
    }
}

