/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.index.IndexField;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;

public class IndexInfo {
    private static final Double ONE = 1.0;
    private static final Double MINUS_ONE = -1.0;
    private static final Collection<String> TWO_D_IDENTIFIERS = Arrays.asList("2d", "2dsphere");
    private final List<IndexField> indexFields;
    private final String name;
    private final boolean unique;
    private final boolean sparse;
    private final String language;
    private final boolean hidden;
    private @Nullable Duration expireAfter;
    private @Nullable String partialFilterExpression;
    private @Nullable Document collation;
    private @Nullable Document wildcardProjection;

    public IndexInfo(List<IndexField> indexFields, String name, boolean unique, boolean sparse, String language) {
        this.indexFields = Collections.unmodifiableList(indexFields);
        this.name = name;
        this.unique = unique;
        this.sparse = sparse;
        this.language = language;
        this.hidden = false;
    }

    public IndexInfo(List<IndexField> indexFields, String name, boolean unique, boolean sparse, String language, boolean hidden) {
        this.indexFields = Collections.unmodifiableList(indexFields);
        this.name = name;
        this.unique = unique;
        this.sparse = sparse;
        this.language = language;
        this.hidden = hidden;
    }

    public static IndexInfo indexInfoOf(Document sourceDocument) {
        Document keyDbObject = (Document)sourceDocument.get((Object)"key", (Object)new Document());
        int numberOfElements = keyDbObject.keySet().size();
        ArrayList<IndexField> indexFields = new ArrayList<IndexField>(numberOfElements);
        for (String key : keyDbObject.keySet()) {
            Object value = keyDbObject.get((Object)key);
            if (TWO_D_IDENTIFIERS.contains(value)) {
                indexFields.add(IndexField.geo(key));
                continue;
            }
            if ("text".equals(value)) {
                Document weights = (Document)sourceDocument.get((Object)"weights");
                if (weights == null) continue;
                for (String fieldName : weights.keySet()) {
                    indexFields.add(IndexField.text(fieldName, Float.valueOf(weights.get((Object)fieldName).toString())));
                }
                continue;
            }
            if (ObjectUtils.nullSafeEquals((Object)"hashed", (Object)value)) {
                indexFields.add(IndexField.hashed(key));
                continue;
            }
            if (key.endsWith("$**")) {
                indexFields.add(IndexField.wildcard(key));
                continue;
            }
            Double keyValue = Double.valueOf(value.toString());
            if (ONE.equals(keyValue)) {
                indexFields.add(IndexField.create(key, Sort.Direction.ASC));
                continue;
            }
            if (!MINUS_ONE.equals(keyValue)) continue;
            indexFields.add(IndexField.create(key, Sort.Direction.DESC));
        }
        String name = ObjectUtils.nullSafeToString((Object)sourceDocument.get((Object)"name"));
        boolean unique = (Boolean)sourceDocument.get((Object)"unique", (Object)false);
        boolean sparse = (Boolean)sourceDocument.get((Object)"sparse", (Object)false);
        boolean hidden = sourceDocument.getBoolean((Object)"hidden", false);
        String language = sourceDocument.containsKey((Object)"default_language") ? sourceDocument.getString((Object)"default_language") : "";
        String partialFilter = IndexInfo.extractPartialFilterString(sourceDocument);
        IndexInfo info = new IndexInfo(indexFields, name, unique, sparse, language, hidden);
        info.partialFilterExpression = partialFilter;
        info.collation = (Document)sourceDocument.get((Object)"collation", Document.class);
        if (sourceDocument.containsKey((Object)"expireAfterSeconds")) {
            Number expireAfterSeconds = (Number)sourceDocument.get((Object)"expireAfterSeconds", Number.class);
            info.expireAfter = Duration.ofSeconds((Long)NumberUtils.convertNumberToTargetClass((Number)expireAfterSeconds, Long.class));
        }
        if (sourceDocument.containsKey((Object)"wildcardProjection")) {
            info.wildcardProjection = (Document)sourceDocument.get((Object)"wildcardProjection", Document.class);
        }
        return info;
    }

    private static @Nullable String extractPartialFilterString(Document sourceDocument) {
        if (!sourceDocument.containsKey((Object)"partialFilterExpression")) {
            return null;
        }
        return BsonUtils.toJson((Document)sourceDocument.get((Object)"partialFilterExpression", Document.class));
    }

    public List<IndexField> getIndexFields() {
        return this.indexFields;
    }

    public boolean isIndexForFields(Collection<String> keys) {
        Assert.notNull(keys, (String)"Collection of keys must not be null");
        return this.indexFields.stream().map(IndexField::getKey).collect(Collectors.toSet()).containsAll(keys);
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public String getLanguage() {
        return this.language;
    }

    public @Nullable String getPartialFilterExpression() {
        return this.partialFilterExpression;
    }

    public Optional<Document> getCollation() {
        return Optional.ofNullable(this.collation);
    }

    public Optional<Document> getWildcardProjection() {
        return Optional.ofNullable(this.wildcardProjection);
    }

    public Optional<Duration> getExpireAfter() {
        return Optional.ofNullable(this.expireAfter);
    }

    public boolean isHashed() {
        return this.getIndexFields().stream().anyMatch(IndexField::isHashed);
    }

    public boolean isWildcard() {
        return this.getIndexFields().stream().anyMatch(IndexField::isWildcard);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String toString() {
        return "IndexInfo [indexFields=" + String.valueOf(this.indexFields) + ", name=" + this.name + ", unique=" + this.unique + ", sparse=" + this.sparse + ", language=" + this.language + ", partialFilterExpression=" + this.partialFilterExpression + ", collation=" + String.valueOf(this.collation) + ", expireAfterSeconds=" + ObjectUtils.nullSafeToString((Object)this.expireAfter) + ", hidden=" + this.hidden + "]";
    }

    public int hashCode() {
        int result = 17;
        result += 31 * ObjectUtils.nullSafeHashCode(this.indexFields);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.name);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.unique);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.sparse);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.language);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.partialFilterExpression);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.collation);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.expireAfter);
        return result += 31 * ObjectUtils.nullSafeHashCode((Object)this.hidden);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexInfo other = (IndexInfo)obj;
        if (this.indexFields == null ? other.indexFields != null : !this.indexFields.equals(other.indexFields)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.sparse != other.sparse) {
            return false;
        }
        if (this.unique != other.unique) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.language, (Object)other.language)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.partialFilterExpression, (Object)other.partialFilterExpression)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.collation, (Object)other.collation)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.expireAfter, (Object)other.expireAfter)) {
            return false;
        }
        return this.hidden == other.hidden;
    }
}

