/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.PropertyValueConversions;
import org.springframework.data.convert.PropertyValueConverterFactory;
import org.springframework.data.convert.PropertyValueConverterRegistrar;
import org.springframework.data.convert.SimplePropertyValueConversions;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.convert.GeoConverters;
import org.springframework.data.mongodb.core.convert.MongoConverters;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class MongoCustomConversions
extends CustomConversions {
    private static final Log LOGGER = LogFactory.getLog(MongoCustomConversions.class);
    private static final List<Object> STORE_CONVERTERS;
    private final List<Converter<?, ?>> fallbackConversionServiceConverters = new ArrayList();

    MongoCustomConversions() {
        this(Collections.emptyList());
    }

    public MongoCustomConversions(List<?> converters) {
        this(MongoConverterConfigurationAdapter.from(converters));
    }

    protected MongoCustomConversions(MongoConverterConfigurationAdapter conversionConfiguration) {
        this(conversionConfiguration.createConverterConfiguration());
    }

    private MongoCustomConversions(MongoConverterConfiguration converterConfiguration) {
        super((CustomConversions.ConverterConfiguration)converterConfiguration);
        this.fallbackConversionServiceConverters.addAll(converterConfiguration.fallbackConversionServiceConverters);
    }

    public static MongoCustomConversions create(Consumer<MongoConverterConfigurationAdapter> configurer) {
        MongoConverterConfigurationAdapter adapter = new MongoConverterConfigurationAdapter();
        configurer.accept(adapter);
        return new MongoCustomConversions(adapter);
    }

    public void registerConvertersIn(ConverterRegistry conversionService) {
        this.fallbackConversionServiceConverters.forEach(arg_0 -> ((ConverterRegistry)conversionService).addConverter(arg_0));
        super.registerConvertersIn(conversionService);
    }

    static {
        ArrayList<? extends Object> converters = new ArrayList<Object>();
        converters.add((Object)CustomToStringConverter.INSTANCE);
        converters.addAll(MongoConverters.getConvertersToRegister());
        converters.addAll(GeoConverters.getConvertersToRegister());
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
    }

    public static class MongoConverterConfigurationAdapter {
        private static final Set<Class<?>> JAVA_DRIVER_TIME_SIMPLE_TYPES = Set.of(LocalDate.class, LocalTime.class, LocalDateTime.class);
        private boolean useNativeDriverJavaTimeCodecs = false;
        private BigDecimalRepresentation bigDecimals = BigDecimalRepresentation.UNSPECIFIED;
        private final List<Object> customConverters = new ArrayList<Object>();
        private final PropertyValueConversions internalValueConversion;
        private PropertyValueConversions propertyValueConversions = this.internalValueConversion = PropertyValueConversions.simple(it -> {});

        public static MongoConverterConfigurationAdapter from(List<?> converters) {
            Assert.notNull(converters, (String)"Converters must not be null");
            MongoConverterConfigurationAdapter converterConfigurationAdapter = new MongoConverterConfigurationAdapter();
            converterConfigurationAdapter.useSpringDataJavaTimeCodecs();
            converterConfigurationAdapter.registerConverters(converters);
            return converterConfigurationAdapter;
        }

        @Contract(value="_ -> this")
        public MongoConverterConfigurationAdapter registerConverter(Converter<?, ?> converter) {
            Assert.notNull(converter, (String)"Converter must not be null");
            this.customConverters.add(converter);
            return this;
        }

        @Contract(value="_ -> this")
        public MongoConverterConfigurationAdapter registerConverters(Collection<?> converters) {
            Assert.notNull(converters, (String)"Converters must not be null");
            Assert.noNullElements(converters, (String)"Converters must not be null nor contain null values");
            this.customConverters.addAll(converters);
            return this;
        }

        @Contract(value="_ -> this")
        public MongoConverterConfigurationAdapter registerConverterFactory(ConverterFactory<?, ?> converterFactory) {
            Assert.notNull(converterFactory, (String)"ConverterFactory must not be null");
            this.customConverters.add(converterFactory);
            return this;
        }

        @Contract(value="_ -> this")
        public MongoConverterConfigurationAdapter registerPropertyValueConverterFactory(PropertyValueConverterFactory converterFactory) {
            Assert.state((boolean)(this.valueConversions() instanceof SimplePropertyValueConversions), (String)"Configured PropertyValueConversions does not allow setting custom ConverterRegistry");
            ((SimplePropertyValueConversions)this.valueConversions()).setConverterFactory(converterFactory);
            return this;
        }

        @Contract(value="_ -> this")
        public MongoConverterConfigurationAdapter configurePropertyConversions(Consumer<PropertyValueConverterRegistrar<MongoPersistentProperty>> configurationAdapter) {
            Assert.state((boolean)(this.valueConversions() instanceof SimplePropertyValueConversions), (String)"Configured PropertyValueConversions does not allow setting custom ConverterRegistry");
            PropertyValueConverterRegistrar propertyValueConverterRegistrar = new PropertyValueConverterRegistrar();
            configurationAdapter.accept((PropertyValueConverterRegistrar<MongoPersistentProperty>)propertyValueConverterRegistrar);
            ((SimplePropertyValueConversions)this.valueConversions()).setValueConverterRegistry(propertyValueConverterRegistrar.buildRegistry());
            return this;
        }

        @Contract(value="_ -> this")
        public MongoConverterConfigurationAdapter useNativeDriverJavaTimeCodecs(boolean useNativeDriverJavaTimeCodecs) {
            this.useNativeDriverJavaTimeCodecs = useNativeDriverJavaTimeCodecs;
            return this;
        }

        @Contract(value="-> this")
        public MongoConverterConfigurationAdapter useNativeDriverJavaTimeCodecs() {
            return this.useNativeDriverJavaTimeCodecs(true);
        }

        @Contract(value="-> this")
        public MongoConverterConfigurationAdapter useSpringDataJavaTimeCodecs() {
            return this.useNativeDriverJavaTimeCodecs(false);
        }

        public MongoConverterConfigurationAdapter bigDecimal(BigDecimalRepresentation representation) {
            Assert.notNull((Object)((Object)representation), (String)"BigDecimalDataType must not be null");
            this.bigDecimals = representation;
            return this;
        }

        @Deprecated(since="4.2")
        public MongoConverterConfigurationAdapter setPropertyValueConversions(PropertyValueConversions valueConversions) {
            return this.withPropertyValueConversions(valueConversions);
        }

        public MongoConverterConfigurationAdapter withPropertyValueConversions(PropertyValueConversions valueConversions) {
            Assert.notNull((Object)valueConversions, (String)"PropertyValueConversions must not be null");
            this.propertyValueConversions = valueConversions;
            return this;
        }

        PropertyValueConversions valueConversions() {
            if (this.propertyValueConversions == null) {
                this.propertyValueConversions = this.internalValueConversion;
            }
            return this.propertyValueConversions;
        }

        MongoConverterConfiguration createConverterConfiguration() {
            PropertyValueConversions propertyValueConversions;
            if (this.hasDefaultPropertyValueConversions() && (propertyValueConversions = this.propertyValueConversions) instanceof SimplePropertyValueConversions) {
                SimplePropertyValueConversions svc = (SimplePropertyValueConversions)propertyValueConversions;
                svc.init();
            }
            ArrayList<Object> storeConverters = new ArrayList<Object>(STORE_CONVERTERS.size() + 10);
            ArrayList<Converter<Object, Object>> fallbackConversionServiceConverters = new ArrayList<Converter<Object, Object>>(5);
            fallbackConversionServiceConverters.addAll(MongoConverters.getBigNumberStringConverters());
            fallbackConversionServiceConverters.addAll(MongoConverters.getBigNumberDecimal128Converters());
            if (this.bigDecimals == null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"No BigDecimal/BigInteger representation set. Choose 'BigDecimalRepresentation.DECIMAL128' or 'BigDecimalRepresentation.String' to store values in desired format.");
                }
            } else {
                switch (this.bigDecimals.ordinal()) {
                    case 0: {
                        storeConverters.addAll(MongoConverters.getBigNumberStringConverters());
                        break;
                    }
                    case 1: {
                        storeConverters.addAll(MongoConverters.getBigNumberDecimal128Converters());
                    }
                }
            }
            fallbackConversionServiceConverters.removeAll(storeConverters);
            if (this.useNativeDriverJavaTimeCodecs) {
                storeConverters.addAll(MongoConverters.getDateToUtcConverters());
                storeConverters.addAll(STORE_CONVERTERS);
                CustomConversions.StoreConversions storeConversions = CustomConversions.StoreConversions.of((SimpleTypeHolder)new SimpleTypeHolder(JAVA_DRIVER_TIME_SIMPLE_TYPES, MongoSimpleTypes.HOLDER), storeConverters);
                return new MongoConverterConfiguration(storeConversions, fallbackConversionServiceConverters, this.customConverters, convertiblePair -> !JAVA_DRIVER_TIME_SIMPLE_TYPES.contains(convertiblePair.getSourceType()) || !Date.class.isAssignableFrom(convertiblePair.getTargetType()), this.propertyValueConversions);
            }
            storeConverters.addAll(STORE_CONVERTERS);
            return new MongoConverterConfiguration(CustomConversions.StoreConversions.of((SimpleTypeHolder)MongoSimpleTypes.createSimpleTypeHolder(), storeConverters), fallbackConversionServiceConverters, this.customConverters, convertiblePair -> true, this.propertyValueConversions);
        }

        private boolean hasDefaultPropertyValueConversions() {
            return this.propertyValueConversions == this.internalValueConversion;
        }
    }

    static class MongoConverterConfiguration
    extends CustomConversions.ConverterConfiguration {
        private final List<Converter<?, ?>> fallbackConversionServiceConverters;

        public MongoConverterConfiguration(CustomConversions.StoreConversions storeConversions, List<Converter<?, ?>> fallbackConversionServiceConverters, List<?> userConverters, Predicate<GenericConverter.ConvertiblePair> converterRegistrationFilter, @Nullable PropertyValueConversions propertyValueConversions) {
            super(storeConversions, userConverters, converterRegistrationFilter, propertyValueConversions);
            this.fallbackConversionServiceConverters = fallbackConversionServiceConverters;
        }
    }

    @WritingConverter
    private static enum CustomToStringConverter implements GenericConverter
    {
        INSTANCE;


        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            GenericConverter.ConvertiblePair localeToString = new GenericConverter.ConvertiblePair(Locale.class, String.class);
            GenericConverter.ConvertiblePair booleanToString = new GenericConverter.ConvertiblePair(Character.class, String.class);
            return new HashSet<GenericConverter.ConvertiblePair>(Arrays.asList(localeToString, booleanToString));
        }

        public @Nullable Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source != null ? source.toString() : null;
        }
    }

    public static enum BigDecimalRepresentation {
        STRING,
        DECIMAL128,
        UNSPECIFIED;

    }
}

