/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.QueryResultConverter;
import org.springframework.data.mongodb.core.ReactiveAggregationOperation;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

class ReactiveAggregationOperationSupport
implements ReactiveAggregationOperation {
    private final ReactiveMongoTemplate template;

    ReactiveAggregationOperationSupport(ReactiveMongoTemplate template) {
        Assert.notNull((Object)template, (String)"Template must not be null");
        this.template = template;
    }

    @Override
    public <T> ReactiveAggregationOperation.ReactiveAggregation<T> aggregateAndReturn(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveAggregationSupport(this.template, domainType, QueryResultConverter.entity(), null, null);
    }

    static class ReactiveAggregationSupport<S, T>
    implements ReactiveAggregationOperation.AggregationOperationWithAggregation<T>,
    ReactiveAggregationOperation.ReactiveAggregation<T>,
    ReactiveAggregationOperation.TerminatingAggregationOperation<T> {
        private final ReactiveMongoTemplate template;
        private final Class<S> domainType;
        private final QueryResultConverter<? super S, ? extends T> resultConverter;
        private final @Nullable Aggregation aggregation;
        private final @Nullable String collection;

        ReactiveAggregationSupport(ReactiveMongoTemplate template, Class<S> domainType, QueryResultConverter<? super S, ? extends T> resultConverter, @Nullable Aggregation aggregation, @Nullable String collection) {
            this.template = template;
            this.domainType = domainType;
            this.resultConverter = resultConverter;
            this.aggregation = aggregation;
            this.collection = collection;
        }

        @Override
        public ReactiveAggregationOperation.AggregationOperationWithAggregation<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty");
            return new ReactiveAggregationSupport<S, T>(this.template, this.domainType, this.resultConverter, this.aggregation, collection);
        }

        @Override
        public ReactiveAggregationOperation.TerminatingAggregationOperation<T> by(Aggregation aggregation) {
            Assert.notNull((Object)aggregation, (String)"Aggregation must not be null");
            return new ReactiveAggregationSupport<S, T>(this.template, this.domainType, this.resultConverter, aggregation, this.collection);
        }

        @Override
        public <R> ReactiveAggregationOperation.TerminatingAggregationOperation<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            Assert.notNull(converter, (String)"QueryResultConverter must not be null");
            return new ReactiveAggregationSupport<S, R>(this.template, this.domainType, this.resultConverter.andThen(converter), this.aggregation, this.collection);
        }

        @Override
        public Flux<T> all() {
            Assert.notNull((Object)this.aggregation, (String)"Aggregation must be set first");
            return this.template.doAggregate(this.aggregation, this.getCollectionName(this.aggregation), this.domainType, this.domainType, this.resultConverter);
        }

        private String getCollectionName(Aggregation aggregation) {
            TypedAggregation typedAggregation;
            if (StringUtils.hasText((String)this.collection)) {
                return this.collection;
            }
            if (aggregation instanceof TypedAggregation && (typedAggregation = (TypedAggregation)aggregation).getInputType() != null) {
                return this.template.getCollectionName(typedAggregation.getInputType());
            }
            return this.template.getCollectionName(this.domainType);
        }
    }
}

