/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import com.mongodb.client.model.SearchIndexModel;
import com.mongodb.client.model.SearchIndexType;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jspecify.annotations.Nullable;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.index.SearchIndexDefinition;
import org.springframework.data.mongodb.core.index.SearchIndexOperations;
import org.springframework.data.mongodb.core.index.SearchIndexStatus;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.util.StringUtils;

public class DefaultSearchIndexOperations
implements SearchIndexOperations {
    private final MongoOperations mongoOperations;
    private final String collectionName;
    private final @Nullable TypeInformation<?> entityTypeInformation;

    public DefaultSearchIndexOperations(MongoOperations mongoOperations, Class<?> type) {
        this(mongoOperations, mongoOperations.getCollectionName(type), type);
    }

    public DefaultSearchIndexOperations(MongoOperations mongoOperations, String collectionName, @Nullable Class<?> type) {
        this.collectionName = collectionName;
        if (type != null) {
            MappingContext mappingContext = mongoOperations.getConverter().getMappingContext();
            this.entityTypeInformation = ((MongoPersistentEntity)mappingContext.getRequiredPersistentEntity(type)).getTypeInformation();
        } else {
            this.entityTypeInformation = null;
        }
        this.mongoOperations = mongoOperations;
    }

    @Override
    public String createIndex(SearchIndexDefinition indexDefinition) {
        Document index = indexDefinition.getIndexDocument(this.entityTypeInformation, this.mongoOperations.getConverter().getMappingContext());
        this.mongoOperations.getCollection(this.collectionName).createSearchIndexes(List.of(new SearchIndexModel(indexDefinition.getName(), (Bson)index.get((Object)"definition", Document.class), SearchIndexType.of((BsonValue)new BsonString(indexDefinition.getType())))));
        return indexDefinition.getName();
    }

    @Override
    public void updateIndex(SearchIndexDefinition indexDefinition) {
        Document indexDocument = indexDefinition.getIndexDocument(this.entityTypeInformation, this.mongoOperations.getConverter().getMappingContext());
        this.mongoOperations.getCollection(this.collectionName).updateSearchIndex(indexDefinition.getName(), (Bson)indexDocument);
    }

    @Override
    public boolean exists(String indexName) {
        return this.getSearchIndex(indexName) != null;
    }

    @Override
    public SearchIndexStatus status(String indexName) {
        Document searchIndex = this.getSearchIndex(indexName);
        return searchIndex != null ? SearchIndexStatus.valueOf(searchIndex.getString((Object)"status")) : SearchIndexStatus.DOES_NOT_EXIST;
    }

    @Override
    public void dropAllIndexes() {
        this.getSearchIndexes(null).forEach(indexInfo -> this.dropIndex(indexInfo.getString((Object)"name")));
    }

    @Override
    public void dropIndex(String indexName) {
        this.mongoOperations.getCollection(this.collectionName).dropSearchIndex(indexName);
    }

    private @Nullable Document getSearchIndex(String indexName) {
        List<Document> indexes = this.getSearchIndexes(indexName);
        return indexes.isEmpty() ? null : indexes.iterator().next();
    }

    private List<Document> getSearchIndexes(@Nullable String indexName) {
        Document filter = StringUtils.hasText((String)indexName) ? new Document("name", (Object)indexName) : new Document();
        return (List)this.mongoOperations.getCollection(this.collectionName).aggregate(List.of(new Document("$listSearchIndexes", (Object)filter))).into(new ArrayList());
    }
}

