/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.util.Assert;

class DocumentAccessor {
    private final Bson document;

    public DocumentAccessor(Bson document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        if (!(document instanceof Document) && !(document instanceof DBObject)) {
            Assert.isInstanceOf(Document.class, (Object)document, (String)"Given Bson must be a Document or DBObject");
        }
        this.document = document;
    }

    Bson getDocument() {
        return this.document;
    }

    public void putAll(Document source) {
        Map<String, Object> target = BsonUtils.asMap(this.document);
        target.putAll((Map<String, Object>)source);
    }

    public void put(MongoPersistentProperty prop, @Nullable Object value) {
        Assert.notNull((Object)prop, (String)"MongoPersistentProperty must not be null");
        if (value == null && !prop.writeNullValues()) {
            return;
        }
        Iterator<String> parts = Arrays.asList(prop.getMongoField().getName().parts()).iterator();
        Bson document = this.document;
        while (parts.hasNext()) {
            String part = parts.next();
            if (parts.hasNext()) {
                document = DocumentAccessor.getOrCreateNestedDocument(part, document);
                continue;
            }
            BsonUtils.addToMap(document, part, value);
        }
    }

    public @Nullable Object get(MongoPersistentProperty property) {
        return BsonUtils.resolveValue(this.document, this.getFieldName(property));
    }

    public @Nullable Object getRawId(MongoPersistentEntity<?> entity) {
        return entity.hasIdProperty() ? this.get((MongoPersistentProperty)entity.getRequiredIdProperty()) : BsonUtils.get(this.document, FieldName.ID.name());
    }

    public boolean hasValue(MongoPersistentProperty property) {
        Assert.notNull((Object)property, (String)"Property must not be null");
        return BsonUtils.hasValue(this.document, this.getFieldName(property));
    }

    FieldName getFieldName(MongoPersistentProperty prop) {
        return prop.getMongoField().getName();
    }

    private static Document getOrCreateNestedDocument(String key, Bson source) {
        Object existing = BsonUtils.asMap(source).get(key);
        if (existing instanceof Document) {
            Document document = (Document)existing;
            return document;
        }
        Document nested = new Document();
        BsonUtils.addToMap(source, key, nested);
        return nested;
    }
}

