/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BsonRegularExpression;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.annotation.Reference;
import org.springframework.data.convert.PropertyValueConverter;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.domain.Example;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.InvalidPersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mongodb.MongoExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.FieldLookupPolicy;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConversionContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoExampleMapper;
import org.springframework.data.mongodb.core.convert.MongoJsonSchemaMapper;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.mongodb.util.DotPath;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class QueryMapper {
    protected static final Log LOGGER = LogFactory.getLog(QueryMapper.class);
    private static final List<String> DEFAULT_ID_NAMES = Arrays.asList("id", FieldName.ID.name());
    private static final Document META_TEXT_SCORE = new Document("$meta", (Object)"textScore");
    static final TypeInformation<?> NESTED_DOCUMENT = TypeInformation.of(MappingMongoConverter.NestedDocument.class);
    private final ConversionService conversionService;
    private final MongoConverter converter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final MongoExampleMapper exampleMapper;
    private final MongoJsonSchemaMapper schemaMapper;

    public QueryMapper(MongoConverter converter) {
        Assert.notNull((Object)converter, (String)"MongoConverter must not be null");
        this.conversionService = converter.getConversionService();
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.exampleMapper = new MongoExampleMapper(converter);
        this.schemaMapper = new MongoJsonSchemaMapper(converter);
    }

    public Document getMappedObject(Bson query, Optional<? extends MongoPersistentEntity<?>> entity) {
        return this.getMappedObject(query, (MongoPersistentEntity<?>)entity.orElse(null));
    }

    public Document getMappedObject(Bson query, @Nullable MongoPersistentEntity<?> entity) {
        if (this.isNestedKeyword(query)) {
            return this.getMappedKeyword(new Keyword(query), entity);
        }
        Document result = new Document();
        for (String key : BsonUtils.asMap(query).keySet()) {
            if (Query.isRestrictedTypeKey(key)) {
                Set restrictedTypes = (Set)BsonUtils.get(query, key);
                this.converter.getTypeMapper().writeTypeRestrictions(result, restrictedTypes);
                continue;
            }
            if (this.isTypeKey(key)) {
                result.put(key, BsonUtils.get(query, key));
                continue;
            }
            if (this.isKeyword(key)) {
                result.putAll((Map)this.getMappedKeyword(new Keyword(query, key), entity));
                continue;
            }
            try {
                Field field = this.createPropertyField(entity, key, this.mappingContext);
                if (field.getProperty() != null && field.getProperty().isUnwrapped()) {
                    Object theNestedObject = BsonUtils.get(query, key);
                    Document mappedValue = (Document)this.getMappedValue(field, theNestedObject);
                    if (!StringUtils.hasText((String)field.getMappedKey())) {
                        result.putAll((Map)mappedValue);
                        continue;
                    }
                    result.put(field.getMappedKey(), (Object)mappedValue);
                    continue;
                }
                Map.Entry<String, Object> entry = this.getMappedObjectForField(field, BsonUtils.get(query, key));
                result.put(entry.getKey(), entry.getValue());
            }
            catch (InvalidPersistentPropertyPath invalidPathException) {
                if (!(BsonUtils.get(query, key) instanceof Document)) {
                    throw invalidPathException;
                }
                result.put(key, BsonUtils.get(query, key));
            }
        }
        return result;
    }

    public Document getMappedSort(Document sortObject, @Nullable MongoPersistentEntity<?> entity) {
        Assert.notNull((Object)sortObject, (String)"SortObject must not be null");
        if (sortObject.isEmpty()) {
            return BsonUtils.EMPTY_DOCUMENT;
        }
        Document mappedSort = this.mapFieldsToPropertyNames(sortObject, entity);
        return this.mapMetaAttributes(mappedSort, entity, MetaMapping.WHEN_PRESENT);
    }

    public Document getMappedFields(Document fieldsObject, @Nullable MongoPersistentEntity<?> entity) {
        Assert.notNull((Object)fieldsObject, (String)"FieldsObject must not be null");
        Document mappedFields = this.mapFieldsToPropertyNames(fieldsObject, entity);
        return this.mapMetaAttributes(mappedFields, entity, MetaMapping.FORCE);
    }

    private Document mapFieldsToPropertyNames(Document fields, @Nullable MongoPersistentEntity<?> entity) {
        if (fields.isEmpty()) {
            return BsonUtils.EMPTY_DOCUMENT;
        }
        Document target = new Document();
        BsonUtils.asMap((Bson)this.filterUnwrappedObjects(fields, entity)).forEach((k, v) -> {
            Field field = this.createPropertyField(entity, (String)k, this.mappingContext);
            if (field.getProperty() != null && field.getProperty().isUnwrapped()) {
                return;
            }
            target.put(field.getMappedKey(), v);
        });
        return target;
    }

    public Document addMetaAttributes(Document source, @Nullable MongoPersistentEntity<?> entity) {
        return this.mapMetaAttributes(source, entity, MetaMapping.FORCE);
    }

    private Document mapMetaAttributes(Document source, @Nullable MongoPersistentEntity<?> entity, MetaMapping metaMapping) {
        if (entity == null) {
            return source;
        }
        if (entity.hasTextScoreProperty() && !MetaMapping.IGNORE.equals((Object)metaMapping)) {
            if (source == BsonUtils.EMPTY_DOCUMENT) {
                source = new Document();
            }
            MongoPersistentProperty textScoreProperty = entity.getTextScoreProperty();
            if (MetaMapping.FORCE.equals((Object)metaMapping) || MetaMapping.WHEN_PRESENT.equals((Object)metaMapping) && source.containsKey((Object)textScoreProperty.getFieldName())) {
                source.putAll((Map)this.getMappedTextScoreField(textScoreProperty));
            }
        }
        return source;
    }

    private Document filterUnwrappedObjects(Document fieldsObject, @Nullable MongoPersistentEntity<?> entity) {
        if (fieldsObject.isEmpty() || entity == null) {
            return fieldsObject;
        }
        Document target = new Document();
        for (Map.Entry field : fieldsObject.entrySet()) {
            try {
                PropertyPath path = PropertyPath.from((String)((String)field.getKey()), (TypeInformation)entity.getTypeInformation());
                PersistentPropertyPath persistentPropertyPath = this.mappingContext.getPersistentPropertyPath(path);
                MongoPersistentProperty property = (MongoPersistentProperty)this.mappingContext.getPersistentPropertyPath(path).getLeafProperty();
                if (property.isUnwrapped() && property.isEntity()) {
                    MongoPersistentEntity unwrappedEntity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)property);
                    Iterator iterator = unwrappedEntity.iterator();
                    while (iterator.hasNext()) {
                        MongoPersistentProperty unwrappedProperty = (MongoPersistentProperty)iterator.next();
                        DotPath dotPath = DotPath.from(persistentPropertyPath.toDotPath()).append(unwrappedProperty.getName());
                        target.put(dotPath.toString(), field.getValue());
                    }
                    continue;
                }
                target.put((String)field.getKey(), field.getValue());
            }
            catch (RuntimeException e) {
                target.put((String)field.getKey(), field.getValue());
            }
        }
        return target;
    }

    private Document getMappedTextScoreField(MongoPersistentProperty property) {
        return new Document(property.getFieldName(), (Object)META_TEXT_SCORE);
    }

    protected Map.Entry<String, @Nullable Object> getMappedObjectForField(Field field, @Nullable Object rawValue) {
        Object value;
        String key = field.getMappedKey();
        if (rawValue instanceof MongoExpression) {
            MongoExpression mongoExpression = (MongoExpression)rawValue;
            return this.createMapEntry(key, (Object)this.getMappedObject((Bson)mongoExpression.toDocument(), field.getEntity()));
        }
        if (this.isNestedKeyword(rawValue) && !field.isIdField()) {
            Keyword keyword = new Keyword((Bson)((Document)rawValue));
            value = this.getMappedKeyword(field, keyword);
        } else {
            value = this.getMappedValue(field, rawValue);
        }
        return this.createMapEntry(key, value);
    }

    protected Field createPropertyField(@Nullable MongoPersistentEntity<?> entity, String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        if (entity == null) {
            return new Field(key);
        }
        if (FieldName.ID.name().equals(key)) {
            return new MetadataBackedField(key, entity, mappingContext, (MongoPersistentProperty)entity.getIdProperty());
        }
        return new MetadataBackedField(key, entity, mappingContext);
    }

    protected Document getMappedKeyword(Keyword keyword, @Nullable MongoPersistentEntity<?> entity) {
        if (keyword.isOrOrNor() || keyword.hasIterableValue() && !keyword.isGeometry()) {
            ArrayList<Object> arrayList;
            Iterable conditions = (Iterable)keyword.getValue();
            if (conditions instanceof Collection) {
                Collection collection = (Collection)conditions;
                arrayList = new ArrayList<Object>(collection.size());
            } else {
                arrayList = new ArrayList<Object>();
            }
            ArrayList<Object> newConditions = arrayList;
            for (Object condition : conditions) {
                newConditions.add(this.isDocument(condition) ? this.getMappedObject((Bson)((Document)condition), entity) : this.convertSimpleOrDocument(condition, entity));
            }
            return new Document(keyword.getKey(), newConditions);
        }
        if (keyword.isSample()) {
            Example example = (Example)keyword.getValue();
            return this.exampleMapper.getMappedExample(example, entity != null ? entity : (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(example.getProbeType()));
        }
        if (keyword.isJsonSchema()) {
            return this.schemaMapper.mapSchema(new Document(keyword.getKey(), keyword.getValue()), entity != null ? entity.getType() : Object.class);
        }
        return new Document(keyword.getKey(), this.convertSimpleOrDocument(keyword.getValue(), entity));
    }

    protected Document getMappedKeyword(Field property, Keyword keyword) {
        Object convertedValue;
        boolean needsAssociationConversion = property.isAssociation() && !keyword.isExists() && keyword.mayHoldDbRef();
        Object value = keyword.getValue();
        Object object = convertedValue = needsAssociationConversion ? this.convertAssociation(value, property) : this.getMappedValue(property.with(keyword.getKey()), value);
        if (keyword.isSample() && convertedValue instanceof Document) {
            Document document = (Document)convertedValue;
            return document;
        }
        return new Document(keyword.key, convertedValue);
    }

    protected @Nullable Object getMappedValue(Field documentField, @Nullable Object sourceValue) {
        Object value = this.applyFieldTargetTypeHintToValue(documentField, sourceValue);
        if (documentField.getProperty() != null && this.converter.getCustomConversions().hasValueConverter((PersistentProperty)documentField.getProperty())) {
            PropertyValueConverter valueConverter = this.converter.getCustomConversions().getPropertyValueConversions().getValueConverter((PersistentProperty)documentField.getProperty());
            return this.convertValue(documentField, sourceValue, value, (PropertyValueConverter<Object, Object, ValueConversionContext<MongoPersistentProperty>>)valueConverter);
        }
        if (documentField.isIdField() && !documentField.isAssociation()) {
            return this.convertIdField(documentField, value);
        }
        if (value == null) {
            return null;
        }
        if (this.isNestedKeyword(value)) {
            return this.getMappedKeyword(new Keyword((Bson)value), documentField.getPropertyEntity());
        }
        if (this.isAssociationConversionNecessary(documentField, value)) {
            return this.convertAssociation(value, documentField);
        }
        return this.convertSimpleOrDocument(value, documentField.getPropertyEntity());
    }

    private boolean isIdField(Field documentField) {
        return documentField.getProperty() != null && documentField.getProperty().getOwner().isIdProperty((PersistentProperty)documentField.getProperty());
    }

    private Class<?> getIdTypeForField(Field documentField) {
        return this.isIdField(documentField) ? documentField.getProperty().getFieldType() : ObjectId.class;
    }

    protected boolean isAssociationConversionNecessary(Field documentField, @Nullable Object value) {
        Assert.notNull((Object)documentField, (String)"Document field must not be null");
        if (value == null || documentField.getProperty() == null) {
            return false;
        }
        if (!documentField.isAssociation()) {
            return false;
        }
        Class<?> type = value.getClass();
        MongoPersistentProperty property = documentField.getProperty();
        if (property.getActualType().isAssignableFrom(type)) {
            return true;
        }
        if (property.isDocumentReference()) {
            return true;
        }
        MongoPersistentEntity<?> entity = documentField.getPropertyEntity();
        return entity != null && entity.hasIdProperty() && (type.equals(DBRef.class) || ((MongoPersistentProperty)entity.getRequiredIdProperty()).getActualType().isAssignableFrom(type));
    }

    protected @Nullable Object convertSimpleOrDocument(Object source, @Nullable MongoPersistentEntity<?> entity) {
        if (source instanceof Example) {
            Example example = (Example)source;
            return this.exampleMapper.getMappedExample(example, entity);
        }
        if (source instanceof AggregationExpression) {
            AggregationExpression age = (AggregationExpression)source;
            return entity == null ? age.toDocument() : age.toDocument(new TypeBasedAggregationOperationContext(entity.getType(), this.mappingContext, this, FieldLookupPolicy.relaxed()));
        }
        if (source instanceof MongoExpression) {
            MongoExpression exr = (MongoExpression)source;
            return exr.toDocument();
        }
        if (source instanceof List) {
            return this.delegateConvertToMongoType(source, entity);
        }
        if (this.isDocument(source)) {
            return this.getMappedObject((Bson)((Document)source), entity);
        }
        if (this.isDBObject(source)) {
            return this.getMappedObject((Bson)((BasicDBObject)source), entity);
        }
        if (source instanceof BsonValue) {
            return source;
        }
        if (source instanceof Map) {
            Map sourceMap = (Map)source;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(sourceMap.size(), 1.0f);
            for (Map.Entry entry : sourceMap.entrySet()) {
                String key = ObjectUtils.nullSafeToString((Object)this.converter.convertToMongoType(entry.getKey()));
                Object v = entry.getValue();
                if (v instanceof Document) {
                    Document document = (Document)v;
                    map.put(key, this.getMappedObject((Bson)document, entity));
                    continue;
                }
                map.put(key, this.delegateConvertToMongoType(entry.getValue(), entity));
            }
            return map;
        }
        return this.delegateConvertToMongoType(source, entity);
    }

    protected @Nullable Object delegateConvertToMongoType(Object source, @Nullable MongoPersistentEntity<?> entity) {
        if (entity != null && entity.isUnwrapped()) {
            return this.converter.convertToMongoType(source, entity);
        }
        return this.converter.convertToMongoType(source, entity == null ? null : entity.getTypeInformation());
    }

    protected @Nullable Object convertAssociation(Object source, Field field) {
        Object value = this.convertAssociation(source, field.getProperty());
        if (value != null && field.isIdField() && field.getFieldType() != value.getClass()) {
            return this.convertId(value, field.getFieldType());
        }
        return value;
    }

    protected @Nullable Object convertAssociation(@Nullable Object source, @Nullable MongoPersistentProperty property) {
        if (property == null || source == null || source instanceof Document || source instanceof DBObject) {
            return source;
        }
        if (source instanceof DBRef) {
            DBRef ref = (DBRef)source;
            Object id = this.convertId(ref.getId(), property.getOwner().isIdProperty((PersistentProperty)property) ? property.getFieldType() : ObjectId.class);
            if (StringUtils.hasText((String)ref.getDatabaseName())) {
                return new DBRef(ref.getDatabaseName(), ref.getCollectionName(), id);
            }
            return new DBRef(ref.getCollectionName(), id);
        }
        if (source instanceof Iterable) {
            Iterable iterable = (Iterable)source;
            BasicDBList result = new BasicDBList();
            for (Object element : iterable) {
                result.add(this.createReferenceFor(element, property));
            }
            return result;
        }
        if (property.isMap() && source instanceof Document) {
            Document dbObject = (Document)source;
            Document result = new Document();
            for (String key : dbObject.keySet()) {
                result.put(key, this.createReferenceFor(dbObject.get((Object)key), property));
            }
            return result;
        }
        return this.createReferenceFor(source, property);
    }

    private @Nullable Object convertValue(Field documentField, @Nullable Object sourceValue, @Nullable Object value, PropertyValueConverter<Object, Object, ValueConversionContext<MongoPersistentProperty>> valueConverter) {
        MongoConversionContext conversionContext;
        MongoPersistentProperty property = documentField.getProperty();
        MongoConversionContext.QueryOperatorContext criteriaContext = new MongoConversionContext.QueryOperatorContext(this.isKeyword(documentField.name) ? documentField.name : "$eq", property != null ? property.getFieldName() : documentField.name);
        if (valueConverter instanceof MongoConversionContext) {
            MongoConversionContext mcc = (MongoConversionContext)valueConverter;
            conversionContext = mcc.forOperator(criteriaContext);
        } else {
            conversionContext = new MongoConversionContext((PropertyValueProvider<MongoPersistentProperty>)NoPropertyPropertyValueProvider.INSTANCE, property, this.converter, criteriaContext);
        }
        return this.convertValueWithConversionContext(documentField, sourceValue, value, valueConverter, conversionContext);
    }

    protected @Nullable Object convertValueWithConversionContext(Field documentField, @Nullable Object sourceValue, @Nullable Object value, PropertyValueConverter<Object, Object, ValueConversionContext<MongoPersistentProperty>> valueConverter, MongoConversionContext conversionContext) {
        MongoPersistentProperty property = documentField.getProperty();
        if (property != null && !property.isCollectionLike() && sourceValue instanceof Collection) {
            Collection collection = (Collection)sourceValue;
            if (collection.isEmpty()) {
                return collection;
            }
            ArrayList<Object> converted = new ArrayList<Object>(collection.size());
            for (Object o : collection) {
                converted.add(valueConverter.write(o, (ValueConversionContext)conversionContext));
            }
            return converted;
        }
        if (property != null && !property.isMap() && sourceValue instanceof Document) {
            Document document = (Document)sourceValue;
            return BsonUtils.mapValues(document, (key, val) -> {
                if (this.isKeyword((String)key)) {
                    return this.convertValueWithConversionContext(documentField, val, val, valueConverter, conversionContext.forOperator(new MongoConversionContext.QueryOperatorContext((String)key, conversionContext.getOperatorContext().path())));
                }
                return val;
            });
        }
        return value != null ? valueConverter.write(value, (ValueConversionContext)conversionContext) : value;
    }

    private @Nullable Object convertIdField(Field documentField, Object source) {
        DBObject valueDbo;
        Object value = source;
        if (this.isDBObject(source)) {
            valueDbo = (DBObject)source;
            value = new Document(valueDbo.toMap());
        }
        if (!this.isDocument(value)) {
            return this.convertId(value, this.getIdTypeForField(documentField));
        }
        valueDbo = (Document)value;
        Document resultDbo = new Document((Map)valueDbo);
        for (Map.Entry entry : valueDbo.entrySet()) {
            String key = (String)entry.getKey();
            if ("$nin".equals(key) || "$in".equals(key) || "$all".equals(key)) {
                ArrayList<Object> ids = new ArrayList<Object>();
                for (Object id : (Iterable)valueDbo.get((Object)key)) {
                    ids.add(this.convertId(id, this.getIdTypeForField(documentField)));
                }
                resultDbo.put(key, ids);
                continue;
            }
            if (this.isKeyword(key)) {
                resultDbo.put(key, this.convertIdField(documentField, entry.getValue()));
                continue;
            }
            if (documentField.getProperty() != null && documentField.getProperty().isEntity()) {
                Field propertyField = this.createPropertyField(documentField.getPropertyEntity(), key, this.mappingContext);
                resultDbo.put(key, this.getMappedValue(propertyField, entry.getValue()));
                continue;
            }
            resultDbo.put(key, this.getMappedValue(documentField, entry.getValue()));
        }
        return resultDbo;
    }

    protected final boolean isDocument(@Nullable Object value) {
        return value instanceof Document;
    }

    protected final boolean isDBObject(@Nullable Object value) {
        return value instanceof DBObject;
    }

    protected final Map.Entry<String, Object> createMapEntry(Field field, @Nullable Object value) {
        return this.createMapEntry(field.getMappedKey(), value);
    }

    private Map.Entry<String, Object> createMapEntry(String key, @Nullable Object value) {
        Assert.hasText((String)key, (String)"Key must not be null or empty");
        return new AbstractMap.SimpleEntry<String, Object>(key, value);
    }

    private Object createReferenceFor(Object source, MongoPersistentProperty property) {
        if (source instanceof DBRef) {
            DBRef dbRef = (DBRef)source;
            return dbRef;
        }
        if (property != null && (property.isDocumentReference() || !property.isDbReference() && property.findAnnotation(Reference.class) != null)) {
            return this.converter.toDocumentPointer(source, property).getPointer();
        }
        return this.converter.toDBRef(source, property);
    }

    public @Nullable Object convertId(@Nullable Object id) {
        return this.convertId(id, ObjectId.class);
    }

    public @Nullable Object convertId(@Nullable Object id, Class<?> targetType) {
        if (Quirks.skipConversion(id)) {
            return id;
        }
        return this.converter.convertId(id, targetType);
    }

    @Contract(value="null -> false")
    protected boolean isNestedKeyword(@Nullable Object candidate) {
        if (!(candidate instanceof Document)) {
            return false;
        }
        Map<String, Object> map = BsonUtils.asMap((Bson)candidate);
        if (map.size() != 1) {
            return false;
        }
        return this.isKeyword(map.entrySet().iterator().next().getKey());
    }

    protected boolean isTypeKey(String key) {
        return this.converter.getTypeMapper().isTypeKey(key);
    }

    protected boolean isKeyword(@Nullable String candidate) {
        return candidate != null && candidate.startsWith("$");
    }

    private @Nullable Object applyFieldTargetTypeHintToValue(Field documentField, @Nullable Object value) {
        if (value == null || documentField.getProperty() == null || !documentField.getProperty().hasExplicitWriteTarget() || value instanceof Document || value instanceof DBObject || Quirks.skipConversion(value)) {
            return value;
        }
        if (!this.conversionService.canConvert(value.getClass(), documentField.getProperty().getFieldType())) {
            return value;
        }
        if (value instanceof Collection) {
            Collection source = (Collection)value;
            ArrayList<Object> converted = new ArrayList<Object>(source.size());
            for (Object o : source) {
                converted.add(this.conversionService.convert(o, documentField.getProperty().getFieldType()));
            }
            return converted;
        }
        return this.conversionService.convert(value, documentField.getProperty().getFieldType());
    }

    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public MongoConverter getConverter() {
        return this.converter;
    }

    static class Keyword {
        private static final Set<String> NON_DBREF_CONVERTING_KEYWORDS = Set.of("$", "$size", "$slice", "$gt", "$lt");
        private final String key;
        private final Object value;

        public Keyword(Bson source, String key) {
            this.key = key;
            this.value = BsonUtils.get(source, key);
        }

        public Keyword(Bson bson) {
            Map<String, Object> map = BsonUtils.asMap(bson);
            Assert.isTrue((map.size() == 1 ? 1 : 0) != 0, (String)"Can only use a single value Document");
            Set<Map.Entry<String, Object>> entries = map.entrySet();
            Map.Entry<String, Object> entry = entries.iterator().next();
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        public boolean isExists() {
            return "$exists".equalsIgnoreCase(this.key);
        }

        public boolean isOrOrNor() {
            return this.key.equalsIgnoreCase("$or") || this.key.equalsIgnoreCase("$nor");
        }

        public boolean isGeometry() {
            return "$geometry".equalsIgnoreCase(this.key);
        }

        public boolean isSample() {
            return "$example".equalsIgnoreCase(this.key);
        }

        public boolean hasIterableValue() {
            return this.value instanceof Iterable;
        }

        public String getKey() {
            return this.key;
        }

        public <T> T getValue() {
            return (T)this.value;
        }

        public boolean mayHoldDbRef() {
            return !NON_DBREF_CONVERTING_KEYWORDS.contains(this.key);
        }

        public boolean isJsonSchema() {
            return "$jsonSchema".equalsIgnoreCase(this.key);
        }
    }

    protected static class Field {
        protected static final Pattern POSITIONAL_OPERATOR = Pattern.compile("\\$\\[.*\\]");
        protected final String name;

        public Field(String name) {
            Assert.hasText((String)name, (String)"Name must not be null");
            this.name = name;
        }

        public Field with(String name) {
            return new Field(name);
        }

        public boolean isIdField() {
            return FieldName.ID.name().equals(this.name);
        }

        public @Nullable MongoPersistentProperty getProperty() {
            return null;
        }

        public @Nullable MongoPersistentEntity<?> getPropertyEntity() {
            return null;
        }

        @Nullable MongoPersistentEntity<?> getEntity() {
            return null;
        }

        public boolean isAssociation() {
            return false;
        }

        public String getMappedKey() {
            return this.isIdField() ? FieldName.ID.name() : this.name;
        }

        public boolean containsAssociation() {
            return false;
        }

        public @Nullable Association<MongoPersistentProperty> getAssociation() {
            return null;
        }

        public boolean isMap() {
            return this.getProperty() != null && this.getProperty().isMap();
        }

        public TypeInformation<?> getTypeHint() {
            return TypeInformation.OBJECT;
        }

        public Class<?> getFieldType() {
            return Object.class;
        }
    }

    private static enum MetaMapping {
        FORCE,
        WHEN_PRESENT,
        IGNORE;

    }

    public static class MetadataBackedField
    extends Field {
        private static final Pattern POSITIONAL_PARAMETER_PATTERN = Pattern.compile("\\.\\$(\\[.*?\\])?");
        private static final Pattern NUMERIC_SEGMENT = Pattern.compile("\\d+");
        private static final String INVALID_ASSOCIATION_REFERENCE = "Invalid path reference %s; Associations can only be pointed to directly or via their id property";
        private final MongoPersistentEntity<?> entity;
        private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
        private final MongoPersistentProperty property;
        private final @Nullable PersistentPropertyPath<MongoPersistentProperty> path;
        private final @Nullable Association<MongoPersistentProperty> association;

        public MetadataBackedField(String name, MongoPersistentEntity<?> entity, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context) {
            this(name, entity, context, null);
        }

        public MetadataBackedField(String name, MongoPersistentEntity<?> entity, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context, @Nullable MongoPersistentProperty property) {
            super(name);
            Assert.notNull(entity, (String)"MongoPersistentEntity must not be null");
            this.entity = entity;
            this.mappingContext = context;
            this.path = this.getPath(MetadataBackedField.removePlaceholders(POSITIONAL_PARAMETER_PATTERN, name), property);
            this.property = this.path == null ? property : (MongoPersistentProperty)this.path.getLeafProperty();
            this.association = this.findAssociation();
        }

        @Override
        public MetadataBackedField with(String name) {
            return new MetadataBackedField(name, this.entity, this.mappingContext, this.property);
        }

        @Override
        public boolean isIdField() {
            if (this.property != null) {
                return this.property.getOwner().isIdProperty((PersistentProperty)this.property);
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getIdProperty();
            if (idProperty != null) {
                return this.name.equals(idProperty.getName()) || this.name.equals(idProperty.getFieldName());
            }
            return DEFAULT_ID_NAMES.contains(this.name);
        }

        @Override
        public MongoPersistentProperty getProperty() {
            return this.association == null ? this.property : (MongoPersistentProperty)this.association.getInverse();
        }

        @Override
        public @Nullable MongoPersistentEntity<?> getPropertyEntity() {
            MongoPersistentProperty property = this.getProperty();
            return property == null ? null : (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property);
        }

        @Override
        public @Nullable MongoPersistentEntity<?> getEntity() {
            return this.entity;
        }

        @Override
        public boolean isAssociation() {
            return this.association != null;
        }

        @Override
        public @Nullable Association<MongoPersistentProperty> getAssociation() {
            return this.association;
        }

        private @Nullable Association<MongoPersistentProperty> findAssociation() {
            if (this.path != null) {
                for (MongoPersistentProperty p : this.path) {
                    Association association = p.getAssociation();
                    if (association == null) continue;
                    return association;
                }
            }
            return null;
        }

        @Override
        public Class<?> getFieldType() {
            return this.property.getFieldType();
        }

        @Override
        public String getMappedKey() {
            if (this.getProperty() != null && this.getProperty().getMongoField().getName().isKey()) {
                return this.getProperty().getFieldName();
            }
            return this.path == null ? this.name : this.path.toDotPath(this.isAssociation() ? this.getAssociationConverter() : this.getPropertyConverter());
        }

        protected @Nullable PersistentPropertyPath<MongoPersistentProperty> getPath() {
            return this.path;
        }

        private @Nullable PersistentPropertyPath<MongoPersistentProperty> getPath(String pathExpression, @Nullable MongoPersistentProperty sourceProperty) {
            if (sourceProperty != null && sourceProperty.getOwner().equals(this.entity)) {
                return this.mappingContext.getPersistentPropertyPath(PropertyPath.from((String)Pattern.quote(sourceProperty.getName()), (TypeInformation)this.entity.getTypeInformation()));
            }
            String rawPath = MetadataBackedField.resolvePath(pathExpression);
            PropertyPath path = this.forName(rawPath);
            if (path == null || this.isPathToJavaLangClassProperty(path)) {
                return null;
            }
            PersistentPropertyPath<MongoPersistentProperty> propertyPath = this.tryToResolvePersistentPropertyPath(path);
            if (propertyPath == null) {
                if (LOGGER.isInfoEnabled()) {
                    String types = StringUtils.collectionToDelimitedString((Collection)path.stream().map(it -> it.getType().getSimpleName()).collect(Collectors.toList()), (String)" -> ");
                    LOGGER.info((Object)String.format("Could not map '%s'; Maybe a fragment in '%s' is considered a simple type; Mapper continues with %s", path, types, pathExpression));
                }
                return null;
            }
            Iterator iterator = propertyPath.iterator();
            boolean associationDetected = false;
            while (iterator.hasNext()) {
                MongoPersistentProperty property = (MongoPersistentProperty)iterator.next();
                if (property.isAssociation()) {
                    associationDetected = true;
                    continue;
                }
                if (!associationDetected || property.getOwner().isIdProperty((PersistentProperty)property)) continue;
                throw new MappingException(String.format(INVALID_ASSOCIATION_REFERENCE, pathExpression));
            }
            return propertyPath;
        }

        private @Nullable PersistentPropertyPath<MongoPersistentProperty> tryToResolvePersistentPropertyPath(PropertyPath path) {
            try {
                return this.mappingContext.getPersistentPropertyPath(path);
            }
            catch (MappingException e) {
                return null;
            }
        }

        private @Nullable PropertyPath forName(String path) {
            try {
                if (this.entity.getPersistentProperty(path) != null) {
                    return PropertyPath.from((String)Pattern.quote(path), (TypeInformation)this.entity.getTypeInformation());
                }
                return PropertyPath.from((String)path, (TypeInformation)this.entity.getTypeInformation());
            }
            catch (PropertyReferenceException | InvalidPersistentPropertyPath e) {
                if (path.endsWith("_id")) {
                    return this.forName(path.substring(0, path.length() - 3) + "id");
                }
                try {
                    return PropertyPath.from((String)Pattern.quote(path), (TypeInformation)this.entity.getTypeInformation());
                }
                catch (PropertyReferenceException | InvalidPersistentPropertyPath throwable) {
                    return null;
                }
            }
        }

        private boolean isPathToJavaLangClassProperty(PropertyPath path) {
            return (path.getType() == Class.class || path.getType().equals(Object.class)) && path.getLeafProperty().getType() == Class.class;
        }

        private static String resolvePath(String source) {
            String[] segments = source.split("\\.");
            if (segments.length == 1) {
                return source;
            }
            ArrayList<String> path = new ArrayList<String>(segments.length);
            for (int i = 1; i < segments.length; ++i) {
                String segment = segments[i];
                if (segment.startsWith("[") && segment.endsWith("]") || NUMERIC_SEGMENT.matcher(segment).matches()) continue;
                path.add(segment);
            }
            if (path.isEmpty() || segments.length == path.size() + 1) {
                return source;
            }
            path.add(0, segments[0]);
            return StringUtils.collectionToDelimitedString(path, (String)".");
        }

        protected Converter<MongoPersistentProperty, String> getPropertyConverter() {
            return new PositionParameterRetainingPropertyKeyConverter(this.name, this.mappingContext);
        }

        protected Converter<MongoPersistentProperty, String> getAssociationConverter() {
            return new AssociationConverter(this.name, this.getAssociation());
        }

        protected MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
            return this.mappingContext;
        }

        private static String removePlaceholders(Pattern pattern, String raw) {
            return pattern.matcher(raw).replaceAll("");
        }

        @Override
        public TypeInformation<?> getTypeHint() {
            MongoPersistentProperty property = this.getProperty();
            if (property == null) {
                return super.getTypeHint();
            }
            if (property.getActualType().isInterface() || Modifier.isAbstract(property.getActualType().getModifiers())) {
                return TypeInformation.OBJECT;
            }
            return NESTED_DOCUMENT;
        }

        static class PositionParameterRetainingPropertyKeyConverter
        implements Converter<MongoPersistentProperty, String> {
            private final KeyMapper keyMapper;

            public PositionParameterRetainingPropertyKeyConverter(String rawKey, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> ctx) {
                this.keyMapper = new KeyMapper(rawKey, ctx);
            }

            public String convert(MongoPersistentProperty source) {
                return this.keyMapper.mapPropertyName(source);
            }
        }

        static class KeyMapper {
            private final Iterator<String> iterator;
            private int currentIndex;
            private final List<String> pathParts;

            public KeyMapper(String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
                this.pathParts = Arrays.asList(key.split("\\."));
                this.iterator = this.pathParts.iterator();
                this.currentIndex = 0;
            }

            String nextToken() {
                return this.pathParts.get(this.currentIndex + 1);
            }

            boolean hasNexToken() {
                return this.pathParts.size() > this.currentIndex + 1;
            }

            protected String mapPropertyName(MongoPersistentProperty property) {
                StringBuilder mappedName = new StringBuilder(MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE.convert(property));
                if (!this.hasNexToken()) {
                    return mappedName.toString();
                }
                String nextToken = this.nextToken();
                if (KeyMapper.isPositionalParameter(nextToken)) {
                    mappedName.append(".").append(nextToken);
                    this.currentIndex += 2;
                    return mappedName.toString();
                }
                if (property.isMap()) {
                    mappedName.append(".").append(nextToken);
                    this.currentIndex += 2;
                    return mappedName.toString();
                }
                ++this.currentIndex;
                return mappedName.toString();
            }

            static boolean isPositionalParameter(String partial) {
                if ("$".equals(partial)) {
                    return true;
                }
                Matcher matcher = Field.POSITIONAL_OPERATOR.matcher(partial);
                if (matcher.find()) {
                    return true;
                }
                try {
                    Long.valueOf(partial);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
    }

    static enum NoPropertyPropertyValueProvider implements PropertyValueProvider<MongoPersistentProperty>
    {
        INSTANCE;


        public <T> T getPropertyValue(MongoPersistentProperty property) {
            throw new IllegalStateException("No enclosing property source available");
        }
    }

    static class Quirks {
        private static final Set<Class<?>> types = Set.of(Pattern.class, BsonRegularExpression.class);

        Quirks() {
        }

        static boolean skipConversion(@Nullable Object value) {
            if (value == null) {
                return false;
            }
            return types.contains(value.getClass());
        }
    }

    protected static class AssociationConverter
    implements Converter<MongoPersistentProperty, String> {
        private final String name;
        private final MongoPersistentProperty property;
        private boolean associationFound;

        public AssociationConverter(String name, Association<MongoPersistentProperty> association) {
            Assert.notNull(association, (String)"Association must not be null");
            this.property = (MongoPersistentProperty)association.getInverse();
            this.name = name;
        }

        public @Nullable String convert(MongoPersistentProperty source) {
            if (this.associationFound) {
                return null;
            }
            if (this.property.equals(source)) {
                this.associationFound = true;
            }
            if (this.associationFound && this.name.endsWith("$") && this.property.isCollectionLike()) {
                return source.getFieldName() + ".$";
            }
            return source.getFieldName();
        }
    }
}

