/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.observability;

import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.data.mongodb.observability.MongoKeyName;
import org.springframework.lang.Nullable;

class Observer {
    private final List<MongoKeyName.MongoKeyValue> keyValues = new ArrayList<MongoKeyName.MongoKeyValue>();

    Observer() {
    }

    static Observer create() {
        return new Observer();
    }

    static <C> Observer fromContext(@Nullable C context, Consumer<? super ContextualObserver<C>> consumer) {
        Observer contributor = Observer.create();
        consumer.accept(contributor.contextual(context));
        return contributor;
    }

    Observer contribute(MongoKeyName.MongoKeyValue keyValue) {
        this.keyValues.add(keyValue);
        return this;
    }

    <C> ContextualObserver<C> contextual(@Nullable C context) {
        if (context == null) {
            return new EmptyContextualObserver(this.keyValues);
        }
        return new DefaultContextualObserver<C>(context, this.keyValues);
    }

    KeyValues toKeyValues() {
        return KeyValues.of(this.keyValues);
    }

    KeyName[] toKeyNames() {
        KeyName[] keyNames = new KeyName[this.keyValues.size()];
        for (int i = 0; i < this.keyValues.size(); ++i) {
            MongoKeyName.MongoKeyValue keyValue = this.keyValues.get(i);
            keyNames[i] = keyValue;
        }
        return keyNames;
    }

    static interface ContextualObserver<T> {
        public <N> ContextualObserver<N> nested(Function<? super T, ? extends N> var1);

        default public ContextualObserver<T> contribute(Consumer<? super ContextualObserver<T>> consumer) {
            consumer.accept(this);
            return this;
        }

        public ContextualObserver<T> contribute(MongoKeyName.MongoKeyValue var1);

        default public ContextualObserver<T> contribute(MongoKeyName<T> keyName) {
            return this.contribute(List.of(keyName));
        }

        default public ContextualObserver<T> contribute(MongoKeyName<T> keyName0, MongoKeyName<T> keyName1) {
            return this.contribute(List.of(keyName0, keyName1));
        }

        default public ContextualObserver<T> contribute(MongoKeyName<T> keyName0, MongoKeyName<T> keyName1, MongoKeyName<T> keyName2) {
            return this.contribute(List.of(keyName0, keyName1, keyName2));
        }

        public ContextualObserver<T> contribute(Iterable<MongoKeyName<T>> var1);
    }

    private record EmptyContextualObserver<T>(List<MongoKeyName.MongoKeyValue> keyValues) implements ContextualObserver<T>
    {
        @Override
        public <N> ContextualObserver<N> nested(Function<? super T, ? extends N> mapper) {
            return new EmptyContextualObserver<T>(this.keyValues);
        }

        @Override
        public ContextualObserver<T> contribute(MongoKeyName.MongoKeyValue keyValue) {
            this.keyValues.add(keyValue);
            return this;
        }

        @Override
        public ContextualObserver<T> contribute(Iterable<MongoKeyName<T>> keyNames) {
            for (MongoKeyName<T> name : keyNames) {
                this.keyValues.add(name.absent());
            }
            return this;
        }
    }

    private record DefaultContextualObserver<T>(T target, List<MongoKeyName.MongoKeyValue> keyValues) implements ContextualObserver<T>
    {
        @Override
        public <N> ContextualObserver<N> nested(Function<? super T, ? extends N> mapper) {
            N nestedTarget = mapper.apply(this.target);
            if (nestedTarget == null) {
                return new EmptyContextualObserver(this.keyValues);
            }
            return new DefaultContextualObserver<N>(nestedTarget, this.keyValues);
        }

        @Override
        public ContextualObserver<T> contribute(MongoKeyName.MongoKeyValue keyValue) {
            this.keyValues.add(keyValue);
            return this;
        }

        @Override
        public ContextualObserver<T> contribute(MongoKeyName<T> keyName) {
            this.keyValues.add(keyName.valueOf(this.target));
            return this;
        }

        @Override
        public ContextualObserver<T> contribute(Iterable<MongoKeyName<T>> keyNames) {
            for (MongoKeyName<T> name : keyNames) {
                this.keyValues.add(name.valueOf(this.target));
            }
            return this;
        }
    }
}

