/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBRef;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cglib.core.NamingPolicy;
import org.springframework.cglib.core.SpringNamingPolicy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.ClientSessionException;
import org.springframework.data.mongodb.LazyLoadingException;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.Lock;
import org.springframework.lang.Nullable;
import org.springframework.objenesis.SpringObjenesis;
import org.springframework.util.ReflectionUtils;

public final class LazyLoadingProxyFactory {
    private static final Log LOGGER = LogFactory.getLog(LazyLoadingProxyFactory.class);
    private final SpringObjenesis objenesis;
    private final PersistenceExceptionTranslator exceptionTranslator;

    private LazyLoadingProxyFactory() {
        this(ex -> null);
    }

    public LazyLoadingProxyFactory(PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
        this.objenesis = new SpringObjenesis(null);
    }

    public static Class<?> resolveProxyType(Class<?> propertyType, Supplier<LazyLoadingInterceptor> interceptor) {
        LazyLoadingProxyFactory factory = new LazyLoadingProxyFactory();
        if (!propertyType.isInterface()) {
            return factory.getEnhancedTypeFor(propertyType);
        }
        return factory.prepareProxyFactory(propertyType, interceptor).getProxyClass(LazyLoadingProxy.class.getClassLoader());
    }

    public static ProxyFactory prepareFactory(Class<?> targetType) {
        ProxyFactory proxyFactory = new ProxyFactory();
        for (Class<?> type : targetType.getInterfaces()) {
            proxyFactory.addInterface(type);
        }
        proxyFactory.addInterface(LazyLoadingProxy.class);
        proxyFactory.addInterface(targetType);
        return proxyFactory;
    }

    private ProxyFactory prepareProxyFactory(Class<?> propertyType, Supplier<LazyLoadingInterceptor> interceptor) {
        ProxyFactory proxyFactory = LazyLoadingProxyFactory.prepareFactory(propertyType);
        proxyFactory.addAdvice((Advice)interceptor.get());
        return proxyFactory;
    }

    public Object createLazyLoadingProxy(MongoPersistentProperty property, DbRefResolverCallback callback, Object source) {
        Class propertyType = property.getType();
        LazyLoadingInterceptor interceptor = new LazyLoadingInterceptor(property, callback, source, this.exceptionTranslator);
        if (!propertyType.isInterface()) {
            Factory factory = (Factory)this.objenesis.newInstance(this.getEnhancedTypeFor(propertyType));
            factory.setCallbacks(new Callback[]{interceptor});
            return factory;
        }
        return this.prepareProxyFactory(propertyType, () -> new LazyLoadingInterceptor(property, callback, source, this.exceptionTranslator)).getProxy(LazyLoadingProxy.class.getClassLoader());
    }

    private Class<?> getEnhancedTypeFor(Class<?> type) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setCallbackType(LazyLoadingInterceptor.class);
        enhancer.setInterfaces(new Class[]{LazyLoadingProxy.class});
        enhancer.setNamingPolicy((NamingPolicy)SpringNamingPolicy.INSTANCE);
        enhancer.setAttemptLoad(true);
        return enhancer.createClass();
    }

    public static class LazyLoadingInterceptor
    implements org.aopalliance.intercept.MethodInterceptor,
    MethodInterceptor,
    Serializable {
        private static final Method INITIALIZE_METHOD;
        private static final Method TO_DBREF_METHOD;
        private static final Method FINALIZE_METHOD;
        private static final Method GET_SOURCE_METHOD;
        private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final org.springframework.data.util.Lock readLock = org.springframework.data.util.Lock.of((Lock)this.rwLock.readLock());
        private final org.springframework.data.util.Lock writeLock = org.springframework.data.util.Lock.of((Lock)this.rwLock.writeLock());
        private final MongoPersistentProperty property;
        private final DbRefResolverCallback callback;
        private final Object source;
        private final PersistenceExceptionTranslator exceptionTranslator;
        private volatile boolean resolved;
        @Nullable
        private Object result;

        public static LazyLoadingInterceptor none() {
            return new LazyLoadingInterceptor(null, null, null, null){

                @Override
                @Nullable
                public Object invoke(MethodInvocation invocation) throws Throwable {
                    return this.intercept(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), null);
                }

                @Override
                @Nullable
                public Object intercept(Object o, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    ReflectionUtils.makeAccessible((Method)method);
                    return method.invoke(o, args);
                }
            };
        }

        public LazyLoadingInterceptor(MongoPersistentProperty property, DbRefResolverCallback callback, Object source, PersistenceExceptionTranslator exceptionTranslator) {
            this.property = property;
            this.callback = callback;
            this.source = source;
            this.exceptionTranslator = exceptionTranslator;
        }

        @Nullable
        public Object invoke(MethodInvocation invocation) throws Throwable {
            return this.intercept(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), null);
        }

        @Nullable
        public Object intercept(Object o, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Object target;
            if (INITIALIZE_METHOD.equals(method)) {
                return this.ensureResolved();
            }
            if (TO_DBREF_METHOD.equals(method)) {
                return this.source instanceof DBRef ? this.source : null;
            }
            if (GET_SOURCE_METHOD.equals(method)) {
                return this.source;
            }
            if (ReflectionUtils.isObjectMethod((Method)method) && Object.class.equals(method.getDeclaringClass())) {
                if (ReflectionUtils.isToStringMethod((Method)method)) {
                    return this.proxyToString(this.source);
                }
                if (ReflectionUtils.isEqualsMethod((Method)method)) {
                    return this.proxyEquals(o, args[0]);
                }
                if (ReflectionUtils.isHashCodeMethod((Method)method)) {
                    return this.proxyHashCode();
                }
                if (FINALIZE_METHOD.equals(method)) {
                    return null;
                }
            }
            if ((target = this.ensureResolved()) == null) {
                return null;
            }
            ReflectionUtils.makeAccessible((Method)method);
            return method.invoke(target, args);
        }

        @Nullable
        private Object ensureResolved() {
            if (!this.resolved) {
                this.result = this.resolve();
                this.resolved = true;
            }
            return this.result;
        }

        private String proxyToString(@Nullable Object source) {
            StringBuilder description = new StringBuilder();
            if (source != null) {
                if (source instanceof DBRef) {
                    DBRef dbRef = (DBRef)source;
                    description.append(dbRef.getCollectionName());
                    description.append(":");
                    description.append(dbRef.getId());
                } else {
                    description.append(source);
                }
            } else {
                description.append(0);
            }
            description.append("$").append(LazyLoadingProxy.class.getSimpleName());
            return description.toString();
        }

        private boolean proxyEquals(@Nullable Object proxy, Object that) {
            if (!(that instanceof LazyLoadingProxy)) {
                return false;
            }
            if (that == proxy) {
                return true;
            }
            return this.proxyToString(proxy).equals(that.toString());
        }

        private int proxyHashCode() {
            return this.proxyToString(this.source).hashCode();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.ensureResolved();
            out.writeObject(this.result);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            try {
                this.resolved = true;
                this.result = in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new LazyLoadingException("Could not deserialize result", e);
            }
        }

        @Nullable
        private Object resolve() {
            try (Lock.AcquiredLock l = this.readLock.lock();){
                if (this.resolved) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)String.format("Accessing already resolved lazy loading property %s.%s", this.property.getOwner() != null ? this.property.getOwner().getName() : "unknown", this.property.getName()));
                    }
                    Object object = this.result;
                    return object;
                }
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)String.format("Resolving lazy loading property %s.%s", this.property.getOwner() != null ? this.property.getOwner().getName() : "unknown", this.property.getName()));
            }
            try {
                return this.writeLock.execute(() -> this.callback.resolve(this.property));
            }
            catch (RuntimeException ex) {
                DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible(ex);
                if (translatedException instanceof ClientSessionException) {
                    throw new LazyLoadingException("Unable to lazily resolve DBRef; Invalid session state", ex);
                }
                throw new LazyLoadingException("Unable to lazily resolve DBRef", (Throwable)(translatedException != null ? translatedException : ex));
            }
        }

        static {
            try {
                INITIALIZE_METHOD = LazyLoadingProxy.class.getMethod("getTarget", new Class[0]);
                TO_DBREF_METHOD = LazyLoadingProxy.class.getMethod("toDBRef", new Class[0]);
                FINALIZE_METHOD = Object.class.getDeclaredMethod("finalize", new Class[0]);
                GET_SOURCE_METHOD = LazyLoadingProxy.class.getMethod("getSource", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

