/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.DeleteResult;
import java.util.List;
import org.springframework.data.mongodb.core.ExecutableRemoveOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableRemoveOperationSupport
implements ExecutableRemoveOperation {
    private static final Query ALL_QUERY = new Query();
    private final MongoTemplate tempate;

    public ExecutableRemoveOperationSupport(MongoTemplate tempate) {
        this.tempate = tempate;
    }

    @Override
    public <T> ExecutableRemoveOperation.ExecutableRemove<T> remove(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableRemoveSupport<T>(this.tempate, domainType, ALL_QUERY, null);
    }

    static class ExecutableRemoveSupport<T>
    implements ExecutableRemoveOperation.ExecutableRemove<T>,
    ExecutableRemoveOperation.RemoveWithCollection<T> {
        private final MongoTemplate template;
        private final Class<T> domainType;
        private final Query query;
        @Nullable
        private final String collection;

        public ExecutableRemoveSupport(MongoTemplate template, Class<T> domainType, Query query, String collection) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.collection = collection;
        }

        @Override
        public ExecutableRemoveOperation.RemoveWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty");
            return new ExecutableRemoveSupport<T>(this.template, this.domainType, this.query, collection);
        }

        @Override
        public ExecutableRemoveOperation.TerminatingRemove<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            return new ExecutableRemoveSupport<T>(this.template, this.domainType, query, this.collection);
        }

        @Override
        public DeleteResult all() {
            return this.template.doRemove(this.getCollectionName(), this.query, this.domainType, true);
        }

        @Override
        public DeleteResult one() {
            return this.template.doRemove(this.getCollectionName(), this.query, this.domainType, false);
        }

        @Override
        public List<T> findAndRemove() {
            String collectionName = this.getCollectionName();
            return this.template.doFindAndDelete(collectionName, this.query, this.domainType);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }
    }
}

