/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.observability;

import com.mongodb.ConnectionString;
import com.mongodb.ServerAddress;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.event.CommandEvent;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.docs.ObservationDocumentation;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.regex.Pattern;
import org.springframework.data.mongodb.observability.MongoHandlerContext;
import org.springframework.data.mongodb.observability.MongoKeyName;
import org.springframework.data.mongodb.observability.Observer;
import org.springframework.lang.Contract;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum MongoObservation implements ObservationDocumentation
{
    MONGODB_COMMAND_OBSERVATION{

        public String getName() {
            return "spring.data.mongodb.command";
        }

        public KeyName[] getLowCardinalityKeyNames() {
            return LowCardinality.getKeyNames();
        }

        public KeyName[] getHighCardinalityKeyNames() {
            return new KeyName[0];
        }
    };


    @Nullable
    @Contract(value="null -> null")
    static String connectionString(@Nullable ConnectionString connectionString) {
        if (connectionString == null) {
            return null;
        }
        if (!StringUtils.hasText((String)connectionString.getUsername()) && connectionString.getPassword() == null) {
            return connectionString.toString();
        }
        String target = MongoObservation.renderPart(connectionString.toString(), "//", connectionString.getUsername());
        if (connectionString.getPassword() != null) {
            String rendered = MongoObservation.renderPart(target, ":", new String(connectionString.getPassword()));
            if (!rendered.equals(target)) {
                target = rendered;
            } else {
                String protocol = connectionString.isSrvProtocol() ? "mongodb+srv" : "mongodb";
                target = "%s://*****:*****@%s".formatted(protocol, StringUtils.collectionToCommaDelimitedString((Collection)connectionString.getHosts()));
            }
        }
        return target;
    }

    private static String renderPart(String source, String prefix, @Nullable String part) {
        if (!StringUtils.hasText((String)part)) {
            return source;
        }
        String intermediate = source.replaceFirst(prefix + Pattern.quote(part), "%s*****".formatted(prefix));
        if (!intermediate.equals(source)) {
            return intermediate;
        }
        String encoded = URLEncoder.encode(part, StandardCharsets.UTF_8);
        return source.replaceFirst(prefix + Pattern.quote(encoded), "%s*****".formatted(prefix));
    }

    static class LowCardinality {
        static MongoKeyName.MongoKeyValue DB_SYSTEM = MongoKeyName.just("db.system", "mongodb");
        static MongoKeyName<MongoHandlerContext> MONGODB_COMMAND = MongoKeyName.requiredString("db.operation", MongoHandlerContext::getCommandName);
        static MongoKeyName<MongoHandlerContext> DB_NAME = MongoKeyName.requiredString("db.name", MongoHandlerContext::getDatabaseName);
        static MongoKeyName<MongoHandlerContext> MONGODB_COLLECTION = MongoKeyName.requiredString("db.mongodb.collection", MongoHandlerContext::getCollectionName);
        static MongoKeyName<ConnectionDescription> MONGODB_CLUSTER_ID = MongoKeyName.required("spring.data.mongodb.cluster_id", it -> it.getConnectionId().getServerId().getClusterId().getValue(), StringUtils::hasText);
        static MongoKeyName.MongoKeyValue NET_TRANSPORT_TCP_IP = MongoKeyName.just("net.transport", "IP.TCP");
        static MongoKeyName<ServerAddress> NET_PEER_NAME = MongoKeyName.required("net.peer.name", ServerAddress::getHost);
        static MongoKeyName<ServerAddress> NET_PEER_PORT = MongoKeyName.required("net.peer.port", ServerAddress::getPort);
        static MongoKeyName<ConnectionString> DB_CONNECTION_STRING = MongoKeyName.requiredString("db.connection_string", MongoObservation::connectionString);
        static MongoKeyName<ConnectionString> DB_USER = MongoKeyName.requiredString("db.user", ConnectionString::getUsername);

        LowCardinality() {
        }

        static Observer observe(@Nullable MongoHandlerContext context) {
            return Observer.fromContext(context, it -> {
                it.contribute(DB_SYSTEM).contribute(MONGODB_COMMAND, DB_NAME, MONGODB_COLLECTION);
                it.nested(MongoHandlerContext::getConnectionString).contribute(DB_CONNECTION_STRING, DB_USER);
                it.nested(MongoHandlerContext::getCommandStartedEvent).nested(CommandEvent::getConnectionDescription).contribute(MONGODB_CLUSTER_ID).nested(ConnectionDescription::getServerAddress).contribute(NET_TRANSPORT_TCP_IP).contribute(NET_PEER_NAME, NET_PEER_PORT);
            });
        }

        static KeyName[] getKeyNames() {
            return LowCardinality.observe(null).toKeyNames();
        }
    }
}

