/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.FieldLookupPolicy;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.InheritingExposedFieldsAggregationOperationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class ExposedFieldsAggregationOperationContext
implements AggregationOperationContext {
    private final ExposedFields exposedFields;
    private final AggregationOperationContext rootContext;
    private final FieldLookupPolicy lookupPolicy;

    public ExposedFieldsAggregationOperationContext(ExposedFields exposedFields, AggregationOperationContext rootContext, FieldLookupPolicy lookupPolicy) {
        Assert.notNull((Object)exposedFields, (String)"ExposedFields must not be null");
        Assert.notNull((Object)rootContext, (String)"RootContext must not be null");
        Assert.notNull((Object)lookupPolicy, (String)"FieldLookupPolicy must not be null");
        this.exposedFields = exposedFields;
        this.rootContext = rootContext;
        this.lookupPolicy = lookupPolicy;
    }

    @Override
    public Document getMappedObject(Document document, @Nullable Class<?> type) {
        return this.rootContext.getMappedObject(document, type);
    }

    @Override
    public ExposedFields.FieldReference getReference(Field field) {
        if (field.isInternal()) {
            return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(field, true));
        }
        return this.getReference(field, field.getTarget());
    }

    @Override
    public ExposedFields.FieldReference getReference(String name) {
        return this.getReference(null, name);
    }

    @Override
    public Fields getFields(Class<?> type) {
        return this.rootContext.getFields(type);
    }

    private ExposedFields.FieldReference getReference(@Nullable Field field, String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        ExposedFields.FieldReference exposedField = this.resolveExposedField(field, name);
        if (exposedField != null) {
            return exposedField;
        }
        if (this.lookupPolicy.isStrict()) {
            throw new IllegalArgumentException(String.format("Invalid reference '%s'", name));
        }
        if (field != null) {
            return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(field, true));
        }
        return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(name, true));
    }

    @Nullable
    protected ExposedFields.FieldReference resolveExposedField(@Nullable Field field, String name) {
        ExposedFields.ExposedField rootField;
        ExposedFields.ExposedField exposedField = this.exposedFields.getField(name);
        if (exposedField != null) {
            if (field != null) {
                return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(field, exposedField.isSynthetic()));
            }
            return new ExposedFields.DirectFieldReference(exposedField);
        }
        if (name.contains(".") && (rootField = this.exposedFields.getField(name.split("\\.")[0])) != null) {
            return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(name, true));
        }
        return null;
    }

    AggregationOperationContext getRootContext() {
        return this.rootContext;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.getRootContext().getCodecRegistry();
    }

    @Override
    @Deprecated(since="4.3.1", forRemoval=true)
    public AggregationOperationContext continueOnMissingFieldReference() {
        if (!this.lookupPolicy.isStrict()) {
            return this;
        }
        return new ExposedFieldsAggregationOperationContext(this.exposedFields, this.rootContext, FieldLookupPolicy.relaxed());
    }

    @Override
    public AggregationOperationContext expose(ExposedFields fields) {
        return new ExposedFieldsAggregationOperationContext(fields, this, this.lookupPolicy);
    }

    @Override
    public AggregationOperationContext inheritAndExpose(ExposedFields fields) {
        return new InheritingExposedFieldsAggregationOperationContext(fields, this, this.lookupPolicy);
    }
}

