/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.MongoServerException;
import com.mongodb.MongoSocketException;
import com.mongodb.bulk.BulkWriteError;
import java.util.Set;
import org.bson.BsonInvalidOperationException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.ClientSessionException;
import org.springframework.data.mongodb.MongoTransactionException;
import org.springframework.data.mongodb.UncategorizedMongoDbException;
import org.springframework.data.mongodb.util.MongoDbErrorCodes;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class MongoExceptionTranslator
implements PersistenceExceptionTranslator {
    private static final Set<String> DUPLICATE_KEY_EXCEPTIONS = Set.of("MongoException.DuplicateKey", "DuplicateKeyException");
    private static final Set<String> RESOURCE_FAILURE_EXCEPTIONS = Set.of("MongoException.Network", "MongoSocketException", "MongoException.CursorNotFound", "MongoCursorNotFoundException", "MongoServerSelectionException", "MongoTimeoutException");
    private static final Set<String> RESOURCE_USAGE_EXCEPTIONS = Set.of("MongoInternalException");
    private static final Set<String> DATA_INTEGRITY_EXCEPTIONS = Set.of("WriteConcernException", "MongoWriteException", "MongoBulkWriteException");
    private static final Set<String> SECURITY_EXCEPTIONS = Set.of("MongoCryptException");

    @Nullable
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof BsonInvalidOperationException) {
            throw new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MongoSocketException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        String exception = ClassUtils.getShortName((Class)ClassUtils.getUserClass(ex.getClass()));
        if (DUPLICATE_KEY_EXCEPTIONS.contains(exception)) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (RESOURCE_FAILURE_EXCEPTIONS.contains(exception)) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (RESOURCE_USAGE_EXCEPTIONS.contains(exception)) {
            return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (DATA_INTEGRITY_EXCEPTIONS.contains(exception)) {
            if (ex instanceof MongoServerException) {
                MongoServerException mse = (MongoServerException)ex;
                if (mse.getCode() == 11000) {
                    return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
                }
                if (ex instanceof MongoBulkWriteException) {
                    MongoBulkWriteException bulkException = (MongoBulkWriteException)ex;
                    for (BulkWriteError x : bulkException.getWriteErrors()) {
                        if (x.getCode() != 11000) continue;
                        return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MongoException) {
            MongoException mongoException = (MongoException)((Object)ex);
            int code = mongoException.getCode();
            if (MongoDbErrorCodes.isDuplicateKeyCode(code)) {
                return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
            }
            if (MongoDbErrorCodes.isDataAccessResourceFailureCode(code)) {
                return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (MongoDbErrorCodes.isInvalidDataAccessApiUsageCode(code) || code == 10003 || code == 12001 || code == 12010 || code == 12011 || code == 12012) {
                return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
            }
            if (MongoDbErrorCodes.isPermissionDeniedCode(code)) {
                return new PermissionDeniedDataAccessException(ex.getMessage(), (Throwable)ex);
            }
            if (MongoDbErrorCodes.isClientSessionFailureCode(code)) {
                return new ClientSessionException(ex.getMessage(), ex);
            }
            if (MongoDbErrorCodes.isTransactionFailureCode(code)) {
                return new MongoTransactionException(ex.getMessage(), ex);
            }
            if (ex.getCause() != null && SECURITY_EXCEPTIONS.contains(ClassUtils.getShortName(ex.getCause().getClass()))) {
                return new PermissionDeniedDataAccessException(ex.getMessage(), (Throwable)ex);
            }
            return new UncategorizedMongoDbException(ex.getMessage(), ex);
        }
        if (ex instanceof IllegalStateException) {
            for (StackTraceElement elm : ex.getStackTrace()) {
                if (!elm.getClassName().contains("ClientSession")) continue;
                return new ClientSessionException(ex.getMessage(), ex);
            }
        }
        return null;
    }
}

