/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.mongodb.core.aggregation.DocumentEnhancingOperation;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.lang.Nullable;

public class SetOperation
extends DocumentEnhancingOperation {
    private SetOperation(Map<Object, Object> source) {
        super(source);
    }

    public SetOperation(Object field, @Nullable Object value) {
        this(Collections.singletonMap(field, value));
    }

    public static FieldAppender builder() {
        return new FieldAppender();
    }

    public static FieldAppender.ValueAppender set(String field) {
        return new FieldAppender().set(field);
    }

    public SetOperation set(Object field, Object value) {
        LinkedHashMap<Object, Object> target = new LinkedHashMap<Object, Object>(this.getValueMap());
        target.put(field, value);
        return new SetOperation(target);
    }

    public FieldAppender and() {
        return new FieldAppender(this.getValueMap());
    }

    @Override
    protected String mongoOperator() {
        return "$set";
    }

    public static class FieldAppender {
        private final Map<Object, Object> valueMap;

        private FieldAppender() {
            this.valueMap = new LinkedHashMap<Object, Object>();
        }

        private FieldAppender(Map<Object, Object> source) {
            this.valueMap = new LinkedHashMap<Object, Object>(source);
        }

        public ValueAppender set(final String field) {
            return new ValueAppender(){

                @Override
                public SetOperation toValue(Object value) {
                    valueMap.put(field, value);
                    return this.build();
                }

                @Override
                public SetOperation toValueOf(Object value) {
                    Object object;
                    Map<Object, Object> map = valueMap;
                    if (value instanceof String) {
                        String stringValue = (String)value;
                        object = Fields.fields(stringValue);
                    } else {
                        object = value;
                    }
                    map.put(field, object);
                    return this.build();
                }

                @Override
                public SetOperation withValueOfExpression(String operation, Object ... values) {
                    valueMap.put(field, new DocumentEnhancingOperation.ExpressionProjection(operation, values));
                    return this.build();
                }
            };
        }

        private SetOperation build() {
            return new SetOperation(this.valueMap);
        }

        public static interface ValueAppender {
            public SetOperation toValue(@Nullable Object var1);

            public SetOperation toValueOf(Object var1);

            public SetOperation withValueOfExpression(String var1, Object ... var2);
        }
    }
}

