/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.mongodb.core.aggregation.DocumentEnhancingOperation;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.lang.Nullable;

public class AddFieldsOperation
extends DocumentEnhancingOperation {
    private AddFieldsOperation(Map<Object, Object> source) {
        super(source);
    }

    public AddFieldsOperation(Object field, @Nullable Object value) {
        this(Collections.singletonMap(field, value));
    }

    public static AddFieldsOperationBuilder builder() {
        return new AddFieldsOperationBuilder();
    }

    public static AddFieldsOperationBuilder.ValueAppender addField(String field) {
        return new AddFieldsOperationBuilder().addField(field);
    }

    public AddFieldsOperation addField(Object field, Object value) {
        LinkedHashMap<Object, Object> target = new LinkedHashMap<Object, Object>(this.getValueMap());
        target.put(field, value);
        return new AddFieldsOperation(target);
    }

    public AddFieldsOperationBuilder and() {
        return new AddFieldsOperationBuilder(this.getValueMap());
    }

    @Override
    protected String mongoOperator() {
        return "$addFields";
    }

    public static class AddFieldsOperationBuilder {
        private final Map<Object, Object> valueMap;

        private AddFieldsOperationBuilder() {
            this.valueMap = new LinkedHashMap<Object, Object>();
        }

        private AddFieldsOperationBuilder(Map<Object, Object> source) {
            this.valueMap = new LinkedHashMap<Object, Object>(source);
        }

        public AddFieldsOperationBuilder addFieldWithValue(String field, @Nullable Object value) {
            return this.addField(field).withValue(value);
        }

        public AddFieldsOperationBuilder addFieldWithValueOf(String field, Object value) {
            return this.addField(field).withValueOf(value);
        }

        public ValueAppender addField(final String field) {
            return new ValueAppender(){

                @Override
                public AddFieldsOperationBuilder withValue(Object value) {
                    valueMap.put(field, value);
                    return this;
                }

                @Override
                public AddFieldsOperationBuilder withValueOf(Object value) {
                    Object object;
                    Map<Object, Object> map = valueMap;
                    if (value instanceof String) {
                        String stringValue = (String)value;
                        object = Fields.fields(stringValue);
                    } else {
                        object = value;
                    }
                    map.put(field, object);
                    return this;
                }

                @Override
                public AddFieldsOperationBuilder withValueOfExpression(String operation, Object ... values) {
                    valueMap.put(field, new DocumentEnhancingOperation.ExpressionProjection(operation, values));
                    return this;
                }
            };
        }

        public AddFieldsOperation build() {
            return new AddFieldsOperation(this.valueMap);
        }

        public static interface ValueAppender {
            public AddFieldsOperationBuilder withValue(@Nullable Object var1);

            public AddFieldsOperationBuilder withValueOf(Object var1);

            public AddFieldsOperationBuilder withValueOfExpression(String var1, Object ... var2);
        }
    }
}

