/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.encryption;

import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.client.vault.ClientEncryption;
import java.util.function.Supplier;
import org.bson.BsonBinary;
import org.bson.BsonValue;
import org.springframework.data.mongodb.core.encryption.Encryption;
import org.springframework.data.mongodb.core.encryption.EncryptionKey;
import org.springframework.data.mongodb.core.encryption.EncryptionOptions;
import org.springframework.util.Assert;

public class MongoClientEncryption
implements Encryption<BsonValue, BsonBinary> {
    private final Supplier<ClientEncryption> source;

    MongoClientEncryption(Supplier<ClientEncryption> source) {
        this.source = source;
    }

    public static MongoClientEncryption just(ClientEncryption clientEncryption) {
        Assert.notNull((Object)clientEncryption, (String)"ClientEncryption must not be null");
        return new MongoClientEncryption(() -> clientEncryption);
    }

    @Override
    public BsonValue decrypt(BsonBinary value) {
        return this.getClientEncryption().decrypt(value);
    }

    @Override
    public BsonBinary encrypt(BsonValue value, EncryptionOptions options) {
        EncryptOptions encryptOptions = new EncryptOptions(options.algorithm());
        encryptOptions = EncryptionKey.Type.ALT.equals((Object)options.key().type()) ? encryptOptions.keyAltName(options.key().value().toString()) : encryptOptions.keyId((BsonBinary)options.key().value());
        return this.getClientEncryption().encrypt(value, encryptOptions);
    }

    public ClientEncryption getClientEncryption() {
        return this.source.get();
    }
}

