/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Range;
import org.springframework.util.Assert;

interface AggregationUtils {
    public static List<Long> toRangeValues(Range<Long> range) {
        Assert.notNull(range, (String)"Range must not be null");
        ArrayList<Long> result = new ArrayList<Long>(2);
        result.add((Long)range.getLowerBound().getValue().orElseThrow(() -> new IllegalArgumentException("Lower bound of range must be bounded")));
        range.getUpperBound().getValue().ifPresent(it -> result.add((Long)it));
        return result;
    }
}

