/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.InheritingExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.NestedDelegatingExpressionAggregationOperationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class VariableOperators {
    public static Map.AsBuilder mapItemsOf(String fieldReference) {
        return Map.itemsOf(fieldReference);
    }

    public static Map.AsBuilder mapItemsOf(AggregationExpression expression) {
        return Map.itemsOf(expression);
    }

    public static Let.LetBuilder define(Let.ExpressionVariable ... variables) {
        return Let.define(variables);
    }

    public static Let.LetBuilder define(Collection<Let.ExpressionVariable> variables) {
        return Let.define(variables);
    }

    public static class Map
    implements AggregationExpression {
        private Object sourceArray;
        private String itemVariableName;
        private AggregationExpression functionToApply;

        private Map(Object sourceArray, String itemVariableName, AggregationExpression functionToApply) {
            Assert.notNull((Object)sourceArray, (String)"SourceArray must not be null");
            Assert.notNull((Object)itemVariableName, (String)"ItemVariableName must not be null");
            Assert.notNull((Object)functionToApply, (String)"FunctionToApply must not be null");
            this.sourceArray = sourceArray;
            this.itemVariableName = itemVariableName;
            this.functionToApply = functionToApply;
        }

        public static AsBuilder itemsOf(final String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new AsBuilder(){

                @Override
                public FunctionBuilder as(final String variableName) {
                    Assert.notNull((Object)variableName, (String)"VariableName must not be null");
                    return new FunctionBuilder(){

                        @Override
                        public Map andApply(AggregationExpression expression) {
                            Assert.notNull((Object)expression, (String)"AggregationExpression must not be null");
                            return new Map(Fields.field(fieldReference), variableName, expression);
                        }
                    };
                }
            };
        }

        public static AsBuilder itemsOf(final AggregationExpression source) {
            Assert.notNull((Object)source, (String)"AggregationExpression must not be null");
            return new AsBuilder(){

                @Override
                public FunctionBuilder as(final String variableName) {
                    Assert.notNull((Object)variableName, (String)"VariableName must not be null");
                    return new FunctionBuilder(){

                        @Override
                        public Map andApply(AggregationExpression expression) {
                            Assert.notNull((Object)expression, (String)"AggregationExpression must not be null");
                            return new Map(source, variableName, expression);
                        }
                    };
                }
            };
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            return this.toMap(ExposedFields.synthetic(Fields.fields(this.itemVariableName)), context);
        }

        private Document toMap(ExposedFields exposedFields, AggregationOperationContext context) {
            Document input;
            Document map = new Document();
            InheritingExposedFieldsAggregationOperationContext operationContext = new InheritingExposedFieldsAggregationOperationContext(exposedFields, context);
            Object object = this.sourceArray;
            if (object instanceof Field) {
                Field field = (Field)object;
                input = new Document("input", (Object)context.getReference(field).toString());
            } else {
                input = new Document("input", (Object)((AggregationExpression)this.sourceArray).toDocument(context));
            }
            map.putAll((java.util.Map)context.getMappedObject(input));
            map.put("as", (Object)this.itemVariableName);
            map.put("in", (Object)this.functionToApply.toDocument(new NestedDelegatingExpressionAggregationOperationContext(operationContext, Collections.singleton(Fields.field(this.itemVariableName)))));
            return new Document("$map", (Object)map);
        }

        public static interface FunctionBuilder {
            public Map andApply(AggregationExpression var1);
        }

        public static interface AsBuilder {
            public FunctionBuilder as(String var1);
        }
    }

    public static class Let
    implements AggregationExpression {
        private final List<ExpressionVariable> vars;
        @Nullable
        private final AggregationExpression expression;

        private Let(List<ExpressionVariable> vars, @Nullable AggregationExpression expression) {
            this.vars = vars;
            this.expression = expression;
        }

        public static Let just(ExpressionVariable ... variables) {
            return new Let(List.of(variables), null);
        }

        public static LetBuilder define(final Collection<ExpressionVariable> variables) {
            Assert.notNull(variables, (String)"Variables must not be null");
            return new LetBuilder(){

                @Override
                public Let andApply(AggregationExpression expression) {
                    Assert.notNull((Object)expression, (String)"Expression must not be null");
                    return new Let(new ArrayList<ExpressionVariable>(variables), expression);
                }
            };
        }

        public static LetBuilder define(ExpressionVariable ... variables) {
            Assert.notNull((Object)variables, (String)"Variables must not be null");
            return Let.define(List.of(variables));
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            return this.toLet(ExposedFields.synthetic(Fields.fields(this.getVariableNames())), context);
        }

        String[] getVariableNames() {
            String[] varNames = new String[this.vars.size()];
            for (int i = 0; i < this.vars.size(); ++i) {
                varNames[i] = this.vars.get((int)i).variableName;
            }
            return varNames;
        }

        private Document toLet(ExposedFields exposedFields, AggregationOperationContext context) {
            Document letExpression = new Document();
            Document mappedVars = new Document();
            InheritingExposedFieldsAggregationOperationContext operationContext = new InheritingExposedFieldsAggregationOperationContext(exposedFields, context);
            for (ExpressionVariable var : this.vars) {
                mappedVars.putAll((java.util.Map)this.getMappedVariable(var, context));
            }
            letExpression.put("vars", (Object)mappedVars);
            if (this.expression != null) {
                letExpression.put("in", this.getMappedIn(operationContext));
            }
            return new Document("$let", (Object)letExpression);
        }

        private Document getMappedVariable(ExpressionVariable var, AggregationOperationContext context) {
            Object object = var.expression;
            if (object instanceof AggregationExpression) {
                AggregationExpression expression = (AggregationExpression)object;
                return new Document(var.variableName, (Object)expression.toDocument(context));
            }
            object = var.expression;
            if (object instanceof Field) {
                Field field = (Field)object;
                return new Document(var.variableName, (Object)context.getReference(field).toString());
            }
            return new Document(var.variableName, var.expression);
        }

        private Object getMappedIn(AggregationOperationContext context) {
            return this.expression.toDocument(new NestedDelegatingExpressionAggregationOperationContext(context, this.vars.stream().map(var -> Fields.field(var.variableName)).collect(Collectors.toList())));
        }

        public static interface LetBuilder {
            public Let andApply(AggregationExpression var1);
        }

        public static class ExpressionVariable {
            @Nullable
            private final String variableName;
            @Nullable
            private final Object expression;

            private ExpressionVariable(@Nullable String variableName, @Nullable Object expression) {
                this.variableName = variableName;
                this.expression = expression;
            }

            public static ExpressionVariable newVariable(String variableName) {
                Assert.notNull((Object)variableName, (String)"VariableName must not be null");
                return new ExpressionVariable(variableName, null);
            }

            public ExpressionVariable forExpression(AggregationExpression expression) {
                Assert.notNull((Object)expression, (String)"Expression must not be null");
                return new ExpressionVariable(this.variableName, expression);
            }

            public ExpressionVariable forField(String fieldRef) {
                return new ExpressionVariable(this.variableName, Fields.field(fieldRef));
            }

            public ExpressionVariable forExpression(Document expressionObject) {
                Assert.notNull((Object)expressionObject, (String)"Expression must not be null");
                return new ExpressionVariable(this.variableName, expressionObject);
            }
        }
    }
}

