/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import java.util.Optional;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.data.mongodb.core.timeseries.Granularity;
import org.springframework.data.mongodb.core.timeseries.GranularityDefinition;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.data.util.Optionals;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class CollectionOptions {
    @Nullable
    private Long maxDocuments;
    @Nullable
    private Long size;
    @Nullable
    private Boolean capped;
    @Nullable
    private Collation collation;
    private ValidationOptions validationOptions;
    @Nullable
    private TimeSeriesOptions timeSeriesOptions;
    @Nullable
    private CollectionChangeStreamOptions changeStreamOptions;

    private CollectionOptions(@Nullable Long size, @Nullable Long maxDocuments, @Nullable Boolean capped, @Nullable Collation collation, ValidationOptions validationOptions, @Nullable TimeSeriesOptions timeSeriesOptions, @Nullable CollectionChangeStreamOptions changeStreamOptions) {
        this.maxDocuments = maxDocuments;
        this.size = size;
        this.capped = capped;
        this.collation = collation;
        this.validationOptions = validationOptions;
        this.timeSeriesOptions = timeSeriesOptions;
        this.changeStreamOptions = changeStreamOptions;
    }

    public static CollectionOptions just(Collation collation) {
        Assert.notNull((Object)collation, (String)"Collation must not be null");
        return new CollectionOptions(null, null, null, collation, ValidationOptions.none(), null, null);
    }

    public static CollectionOptions empty() {
        return new CollectionOptions(null, null, null, null, ValidationOptions.none(), null, null);
    }

    public static CollectionOptions timeSeries(String timeField) {
        return CollectionOptions.empty().timeSeries(TimeSeriesOptions.timeSeries(timeField));
    }

    public static CollectionOptions emitChangedRevisions() {
        return CollectionOptions.empty().changeStream(CollectionChangeStreamOptions.preAndPostImages(true));
    }

    public CollectionOptions capped() {
        return new CollectionOptions(this.size, this.maxDocuments, true, this.collation, this.validationOptions, this.timeSeriesOptions, this.changeStreamOptions);
    }

    public CollectionOptions maxDocuments(long maxDocuments) {
        return new CollectionOptions(this.size, maxDocuments, this.capped, this.collation, this.validationOptions, this.timeSeriesOptions, this.changeStreamOptions);
    }

    public CollectionOptions size(long size) {
        return new CollectionOptions(size, this.maxDocuments, this.capped, this.collation, this.validationOptions, this.timeSeriesOptions, this.changeStreamOptions);
    }

    public CollectionOptions collation(@Nullable Collation collation) {
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, collation, this.validationOptions, this.timeSeriesOptions, this.changeStreamOptions);
    }

    public CollectionOptions schema(@Nullable MongoJsonSchema schema) {
        return this.validator(Validator.schema(schema));
    }

    public CollectionOptions validator(@Nullable Validator validator) {
        return this.validation(this.validationOptions.validator(validator));
    }

    public CollectionOptions disableValidation() {
        return this.schemaValidationLevel(ValidationLevel.OFF);
    }

    public CollectionOptions strictValidation() {
        return this.schemaValidationLevel(ValidationLevel.STRICT);
    }

    public CollectionOptions moderateValidation() {
        return this.schemaValidationLevel(ValidationLevel.MODERATE);
    }

    public CollectionOptions warnOnValidationError() {
        return this.schemaValidationAction(ValidationAction.WARN);
    }

    public CollectionOptions failOnValidationError() {
        return this.schemaValidationAction(ValidationAction.ERROR);
    }

    public CollectionOptions schemaValidationLevel(ValidationLevel validationLevel) {
        Assert.notNull((Object)validationLevel, (String)"ValidationLevel must not be null");
        return this.validation(this.validationOptions.validationLevel(validationLevel));
    }

    public CollectionOptions schemaValidationAction(ValidationAction validationAction) {
        Assert.notNull((Object)validationAction, (String)"ValidationAction must not be null");
        return this.validation(this.validationOptions.validationAction(validationAction));
    }

    public CollectionOptions validation(ValidationOptions validationOptions) {
        Assert.notNull((Object)validationOptions, (String)"ValidationOptions must not be null");
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, this.collation, validationOptions, this.timeSeriesOptions, this.changeStreamOptions);
    }

    public CollectionOptions timeSeries(TimeSeriesOptions timeSeriesOptions) {
        Assert.notNull((Object)timeSeriesOptions, (String)"TimeSeriesOptions must not be null");
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, this.collation, this.validationOptions, timeSeriesOptions, this.changeStreamOptions);
    }

    public CollectionOptions changeStream(CollectionChangeStreamOptions changeStreamOptions) {
        Assert.notNull((Object)changeStreamOptions, (String)"ChangeStreamOptions must not be null");
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, this.collation, this.validationOptions, this.timeSeriesOptions, changeStreamOptions);
    }

    public Optional<Long> getMaxDocuments() {
        return Optional.ofNullable(this.maxDocuments);
    }

    public Optional<Long> getSize() {
        return Optional.ofNullable(this.size);
    }

    public Optional<Boolean> getCapped() {
        return Optional.ofNullable(this.capped);
    }

    public Optional<Collation> getCollation() {
        return Optional.ofNullable(this.collation);
    }

    public Optional<ValidationOptions> getValidationOptions() {
        return this.validationOptions.isEmpty() ? Optional.empty() : Optional.of(this.validationOptions);
    }

    public Optional<TimeSeriesOptions> getTimeSeriesOptions() {
        return Optional.ofNullable(this.timeSeriesOptions);
    }

    public Optional<CollectionChangeStreamOptions> getChangeStreamOptions() {
        return Optional.ofNullable(this.changeStreamOptions);
    }

    public String toString() {
        return "CollectionOptions{maxDocuments=" + this.maxDocuments + ", size=" + this.size + ", capped=" + this.capped + ", collation=" + this.collation + ", validationOptions=" + this.validationOptions + ", timeSeriesOptions=" + this.timeSeriesOptions + ", changeStreamOptions=" + this.changeStreamOptions + ", disableValidation=" + this.disableValidation() + ", strictValidation=" + this.strictValidation() + ", moderateValidation=" + this.moderateValidation() + ", warnOnValidationError=" + this.warnOnValidationError() + ", failOnValidationError=" + this.failOnValidationError() + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionOptions that = (CollectionOptions)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.maxDocuments, (Object)that.maxDocuments)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.size, (Object)that.size)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.capped, (Object)that.capped)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.collation, (Object)that.collation)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.validationOptions, (Object)that.validationOptions)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.timeSeriesOptions, (Object)that.timeSeriesOptions)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.changeStreamOptions, (Object)that.changeStreamOptions);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.maxDocuments);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.size);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.capped);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.collation);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.validationOptions);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.timeSeriesOptions);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.changeStreamOptions);
        return result;
    }

    public static class ValidationOptions {
        private static final ValidationOptions NONE = new ValidationOptions(null, null, null);
        @Nullable
        private final Validator validator;
        @Nullable
        private final ValidationLevel validationLevel;
        @Nullable
        private final ValidationAction validationAction;

        public ValidationOptions(Validator validator, ValidationLevel validationLevel, ValidationAction validationAction) {
            this.validator = validator;
            this.validationLevel = validationLevel;
            this.validationAction = validationAction;
        }

        public static ValidationOptions none() {
            return NONE;
        }

        public ValidationOptions validator(@Nullable Validator validator) {
            return new ValidationOptions(validator, this.validationLevel, this.validationAction);
        }

        public ValidationOptions validationLevel(ValidationLevel validationLevel) {
            return new ValidationOptions(this.validator, validationLevel, this.validationAction);
        }

        public ValidationOptions validationAction(ValidationAction validationAction) {
            return new ValidationOptions(this.validator, this.validationLevel, validationAction);
        }

        public Optional<Validator> getValidator() {
            return Optional.ofNullable(this.validator);
        }

        public Optional<ValidationLevel> getValidationLevel() {
            return Optional.ofNullable(this.validationLevel);
        }

        public Optional<ValidationAction> getValidationAction() {
            return Optional.ofNullable(this.validationAction);
        }

        boolean isEmpty() {
            return !Optionals.isAnyPresent((Optional[])new Optional[]{this.getValidator(), this.getValidationAction(), this.getValidationLevel()});
        }

        public String toString() {
            return "ValidationOptions{validator=" + this.validator + ", validationLevel=" + this.validationLevel + ", validationAction=" + this.validationAction + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidationOptions that = (ValidationOptions)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.validator, (Object)that.validator)) {
                return false;
            }
            if (this.validationLevel != that.validationLevel) {
                return false;
            }
            return this.validationAction == that.validationAction;
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.validator);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.validationLevel);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.validationAction);
            return result;
        }
    }

    public static class TimeSeriesOptions {
        private final String timeField;
        @Nullable
        private final String metaField;
        private final GranularityDefinition granularity;

        private TimeSeriesOptions(String timeField, @Nullable String metaField, GranularityDefinition granularity) {
            Assert.hasText((String)timeField, (String)"Time field must not be empty or null");
            this.timeField = timeField;
            this.metaField = metaField;
            this.granularity = granularity;
        }

        public static TimeSeriesOptions timeSeries(String timeField) {
            return new TimeSeriesOptions(timeField, null, Granularity.DEFAULT);
        }

        public TimeSeriesOptions metaField(String metaField) {
            return new TimeSeriesOptions(this.timeField, metaField, this.granularity);
        }

        public TimeSeriesOptions granularity(GranularityDefinition granularity) {
            return new TimeSeriesOptions(this.timeField, this.metaField, granularity);
        }

        public String getTimeField() {
            return this.timeField;
        }

        @Nullable
        public String getMetaField() {
            return this.metaField;
        }

        public GranularityDefinition getGranularity() {
            return this.granularity;
        }

        public String toString() {
            return "TimeSeriesOptions{timeField='" + this.timeField + "', metaField='" + this.metaField + "', granularity=" + this.granularity + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeSeriesOptions that = (TimeSeriesOptions)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.timeField, (Object)that.timeField)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)this.metaField, (Object)that.metaField)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.granularity, (Object)that.granularity);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.timeField);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.metaField);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.granularity);
            return result;
        }
    }

    public static class CollectionChangeStreamOptions {
        private final boolean preAndPostImages;

        private CollectionChangeStreamOptions(boolean emitChangedRevisions) {
            this.preAndPostImages = emitChangedRevisions;
        }

        public static CollectionChangeStreamOptions preAndPostImages(boolean emitChangedRevisions) {
            return new CollectionChangeStreamOptions(true);
        }

        public boolean getPreAndPostImages() {
            return this.preAndPostImages;
        }

        public String toString() {
            return "CollectionChangeStreamOptions{preAndPostImages=" + this.preAndPostImages + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectionChangeStreamOptions that = (CollectionChangeStreamOptions)o;
            return this.preAndPostImages == that.preAndPostImages;
        }

        public int hashCode() {
            return this.preAndPostImages ? 1 : 0;
        }
    }
}

