/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.util.Assert;

public class ValidatingMongoEventListener
extends AbstractMongoEventListener<Object> {
    private static final Log LOG = LogFactory.getLog(ValidatingMongoEventListener.class);
    private final Validator validator;

    public ValidatingMongoEventListener(Validator validator) {
        Assert.notNull((Object)validator, (String)"Validator must not be null");
        this.validator = validator;
    }

    @Override
    public void onBeforeSave(BeforeSaveEvent<Object> event) {
        Set violations;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Validating object: %s", event.getSource()));
        }
        if (!(violations = this.validator.validate(event.getSource(), new Class[0])).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)String.format("During object: %s validation violations found: %s", event.getSource(), violations));
            }
            throw new ConstraintViolationException(violations);
        }
    }
}

