/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.springframework.data.mongodb.core.schema.DefaultMongoJsonSchema;
import org.springframework.data.mongodb.core.schema.DocumentJsonSchema;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.data.mongodb.core.schema.JsonSchemaProperty;
import org.springframework.data.mongodb.core.schema.MergedJsonSchema;
import org.springframework.data.mongodb.core.schema.TypedJsonSchemaObject;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface MongoJsonSchema {
    default public Document toDocument() {
        return new Document("$jsonSchema", (Object)this.schemaDocument());
    }

    public Document schemaDocument();

    public static MongoJsonSchema of(JsonSchemaObject root) {
        return new DefaultMongoJsonSchema(root);
    }

    public static MongoJsonSchema of(Document document) {
        return new DocumentJsonSchema(document);
    }

    public static MongoJsonSchema merge(MongoJsonSchema ... sources) {
        return MongoJsonSchema.merge((ConflictResolutionFunction.Path path, Object left, Object right) -> {
            throw new IllegalStateException(String.format("Cannot merge schema for path '%s' holding values '%s' and '%s'.", path.dotPath(), left, right));
        }, sources);
    }

    public static MongoJsonSchema merge(ConflictResolutionFunction mergeFunction, MongoJsonSchema ... sources) {
        return new MergedJsonSchema(Arrays.asList(sources), mergeFunction);
    }

    default public MongoJsonSchema mergeWith(MongoJsonSchema ... sources) {
        return this.mergeWith(Arrays.asList(sources));
    }

    default public MongoJsonSchema mergeWith(Collection<MongoJsonSchema> sources) {
        return this.mergeWith(sources, (ConflictResolutionFunction.Path path, Object left, Object right) -> {
            throw new IllegalStateException(String.format("Cannot merge schema for path '%s' holding values '%s' and '%s'.", path.dotPath(), left, right));
        });
    }

    default public MongoJsonSchema mergeWith(Collection<MongoJsonSchema> sources, ConflictResolutionFunction conflictResolutionFunction) {
        ArrayList<MongoJsonSchema> schemaList = new ArrayList<MongoJsonSchema>(sources.size() + 1);
        schemaList.add(this);
        schemaList.addAll(new ArrayList<MongoJsonSchema>(sources));
        return new MergedJsonSchema(schemaList, conflictResolutionFunction);
    }

    public static MongoJsonSchemaBuilder builder() {
        return new MongoJsonSchemaBuilder();
    }

    public static class MongoJsonSchemaBuilder {
        private TypedJsonSchemaObject.ObjectJsonSchemaObject root = new TypedJsonSchemaObject.ObjectJsonSchemaObject();
        @Nullable
        private Document encryptionMetadata;

        MongoJsonSchemaBuilder() {
        }

        public MongoJsonSchemaBuilder minProperties(int count) {
            this.root = this.root.minProperties(count);
            return this;
        }

        public MongoJsonSchemaBuilder maxProperties(int count) {
            this.root = this.root.maxProperties(count);
            return this;
        }

        public MongoJsonSchemaBuilder required(String ... properties) {
            this.root = this.root.required(properties);
            return this;
        }

        public MongoJsonSchemaBuilder additionalProperties(boolean additionalPropertiesAllowed) {
            this.root = this.root.additionalProperties(additionalPropertiesAllowed);
            return this;
        }

        public MongoJsonSchemaBuilder additionalProperties(TypedJsonSchemaObject.ObjectJsonSchemaObject schema) {
            this.root = this.root.additionalProperties(schema);
            return this;
        }

        public MongoJsonSchemaBuilder properties(JsonSchemaProperty ... properties) {
            this.root = this.root.properties(properties);
            return this;
        }

        public MongoJsonSchemaBuilder patternProperties(JsonSchemaProperty ... properties) {
            this.root = this.root.patternProperties(properties);
            return this;
        }

        public MongoJsonSchemaBuilder property(JsonSchemaProperty property) {
            this.root = this.root.property(property);
            return this;
        }

        public MongoJsonSchemaBuilder possibleValues(Set<Object> possibleValues) {
            this.root = this.root.possibleValues(possibleValues);
            return this;
        }

        public MongoJsonSchemaBuilder allOf(Set<JsonSchemaObject> allOf) {
            this.root = this.root.allOf(allOf);
            return this;
        }

        public MongoJsonSchemaBuilder anyOf(Set<JsonSchemaObject> anyOf) {
            this.root = this.root.anyOf(anyOf);
            return this;
        }

        public MongoJsonSchemaBuilder oneOf(Set<JsonSchemaObject> oneOf) {
            this.root = this.root.oneOf(oneOf);
            return this;
        }

        public MongoJsonSchemaBuilder notMatch(JsonSchemaObject notMatch) {
            this.root = this.root.notMatch(notMatch);
            return this;
        }

        public MongoJsonSchemaBuilder description(String description) {
            this.root = this.root.description(description);
            return this;
        }

        public void encryptionMetadata(@Nullable Document encryptionMetadata) {
            this.encryptionMetadata = encryptionMetadata;
        }

        public MongoJsonSchema build() {
            return new DefaultMongoJsonSchema(this.root, this.encryptionMetadata);
        }
    }

    @FunctionalInterface
    public static interface ConflictResolutionFunction {
        public Resolution resolveConflict(Path var1, @Nullable Object var2, @Nullable Object var3);

        public static interface Resolution
        extends Map.Entry<String, Object> {
            public static final Resolution SKIP = new Resolution(){

                @Override
                public String getKey() {
                    throw new IllegalStateException("No key for skipped result.");
                }

                @Override
                public Object getValue() {
                    throw new IllegalStateException("No value for skipped result.");
                }

                @Override
                public Object setValue(Object value) {
                    throw new IllegalStateException("Cannot set value on skipped result.");
                }
            };

            @Override
            default public Object setValue(Object value) {
                throw new IllegalStateException("Cannot set value result. Maybe you missed to override the method.");
            }

            public static Resolution skip() {
                return SKIP;
            }

            public static Resolution ofValue(Path path, Object value) {
                Assert.notNull((Object)path, (String)"Path must not be null");
                return Resolution.ofValue(path.currentElement(), value);
            }

            public static Resolution ofValue(final String key, final Object value) {
                return new Resolution(){

                    @Override
                    public String getKey() {
                        return key;
                    }

                    @Override
                    public Object getValue() {
                        return value;
                    }
                };
            }
        }

        public static interface Path {
            public String currentElement();

            public String dotPath();
        }
    }
}

