/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ConditionalOperators {
    public static ConditionalOperatorFactory when(String fieldReference) {
        return new ConditionalOperatorFactory(fieldReference);
    }

    public static ConditionalOperatorFactory when(AggregationExpression expression) {
        return new ConditionalOperatorFactory(expression);
    }

    public static ConditionalOperatorFactory when(CriteriaDefinition criteriaDefinition) {
        return new ConditionalOperatorFactory(criteriaDefinition);
    }

    public static IfNull.ThenBuilder ifNull(String fieldReference) {
        Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
        return IfNull.ifNull(fieldReference);
    }

    public static IfNull.ThenBuilder ifNull(AggregationExpression expression) {
        Assert.notNull((Object)expression, (String)"Expression must not be null!");
        return IfNull.ifNull(expression);
    }

    public static Switch switchCases(Switch.CaseOperator ... conditions) {
        return Switch.switchCases(conditions);
    }

    public static Switch switchCases(List<Switch.CaseOperator> conditions) {
        return Switch.switchCases(conditions);
    }

    public static class Cond
    implements AggregationExpression {
        private final Object condition;
        private final Object thenValue;
        private final Object otherwiseValue;

        private Cond(Field condition, Object thenValue, Object otherwiseValue) {
            this((Object)condition, thenValue, otherwiseValue);
        }

        private Cond(CriteriaDefinition condition, Object thenValue, Object otherwiseValue) {
            this((Object)condition, thenValue, otherwiseValue);
        }

        private Cond(Object condition, Object thenValue, Object otherwiseValue) {
            Assert.notNull((Object)condition, (String)"Condition must not be null!");
            Assert.notNull((Object)thenValue, (String)"Then value must not be null!");
            Assert.notNull((Object)otherwiseValue, (String)"Otherwise value must not be null!");
            this.assertNotBuilder(condition, "Condition");
            this.assertNotBuilder(thenValue, "Then value");
            this.assertNotBuilder(otherwiseValue, "Otherwise value");
            this.condition = condition;
            this.thenValue = thenValue;
            this.otherwiseValue = otherwiseValue;
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            Document condObject = new Document();
            condObject.append("if", this.resolveCriteria(context, this.condition));
            condObject.append("then", this.resolveValue(context, this.thenValue));
            condObject.append("else", this.resolveValue(context, this.otherwiseValue));
            return new Document("$cond", (Object)condObject);
        }

        private Object resolveValue(AggregationOperationContext context, Object value) {
            if (value instanceof Document || value instanceof Field) {
                return this.resolve(context, value);
            }
            if (value instanceof AggregationExpression) {
                return ((AggregationExpression)value).toDocument(context);
            }
            return context.getMappedObject(new Document("$set", value)).get((Object)"$set");
        }

        private Object resolveCriteria(AggregationOperationContext context, Object value) {
            if (value instanceof Document || value instanceof Field) {
                return this.resolve(context, value);
            }
            if (value instanceof AggregationExpression) {
                return ((AggregationExpression)value).toDocument(context);
            }
            if (value instanceof CriteriaDefinition) {
                Document mappedObject = context.getMappedObject(((CriteriaDefinition)value).getCriteriaObject());
                ArrayList<Object> clauses = new ArrayList<Object>();
                clauses.addAll(this.getClauses(context, mappedObject));
                return clauses.size() == 1 ? clauses.get(0) : clauses;
            }
            throw new InvalidDataAccessApiUsageException(String.format("Invalid value in condition. Supported: Document, Field references, Criteria, got: %s", value));
        }

        private List<Object> getClauses(AggregationOperationContext context, Document mappedObject) {
            ArrayList<Object> clauses = new ArrayList<Object>();
            for (String key : mappedObject.keySet()) {
                Object predicate = mappedObject.get((Object)key);
                clauses.addAll(this.getClauses(context, key, predicate));
            }
            return clauses;
        }

        private List<Object> getClauses(AggregationOperationContext context, String key, Object predicate) {
            ArrayList<Object> clauses = new ArrayList<Object>();
            if (predicate instanceof List) {
                ArrayList<Object> args = new ArrayList<Object>();
                for (Object clause : (List)predicate) {
                    if (!(clause instanceof Document)) continue;
                    args.addAll(this.getClauses(context, (Document)clause));
                }
                clauses.add(new Document(key, args));
            } else if (predicate instanceof Document) {
                Document nested = (Document)predicate;
                for (String s : nested.keySet()) {
                    if (!this.isKeyword(s)) continue;
                    ArrayList<Object> args = new ArrayList<Object>();
                    args.add("$" + key);
                    args.add(nested.get((Object)s));
                    clauses.add(new Document(s, args));
                }
            } else if (!this.isKeyword(key)) {
                ArrayList<Object> args = new ArrayList<Object>();
                args.add("$" + key);
                args.add(predicate);
                clauses.add(new Document("$eq", args));
            }
            return clauses;
        }

        private boolean isKeyword(String candidate) {
            return candidate.startsWith("$");
        }

        private Object resolve(AggregationOperationContext context, Object value) {
            if (value instanceof Document) {
                return context.getMappedObject((Document)value);
            }
            return context.getReference((Field)value).toString();
        }

        private void assertNotBuilder(Object toCheck, String name) {
            Assert.isTrue((!ClassUtils.isAssignableValue(ConditionalExpressionBuilder.class, (Object)toCheck) ? 1 : 0) != 0, (String)String.format("%s must not be of type %s", name, ConditionalExpressionBuilder.class.getSimpleName()));
        }

        public static WhenBuilder newBuilder() {
            return ConditionalExpressionBuilder.newBuilder();
        }

        public static ThenBuilder when(Document booleanExpression) {
            return ConditionalExpressionBuilder.newBuilder().when(booleanExpression);
        }

        public static ThenBuilder when(AggregationExpression expression) {
            return ConditionalExpressionBuilder.newBuilder().when(expression);
        }

        public static ThenBuilder when(String booleanField) {
            return ConditionalExpressionBuilder.newBuilder().when(booleanField);
        }

        public static ThenBuilder when(CriteriaDefinition criteria) {
            return ConditionalExpressionBuilder.newBuilder().when(criteria);
        }

        static class ConditionalExpressionBuilder
        implements WhenBuilder,
        ThenBuilder,
        OtherwiseBuilder {
            @Nullable
            private Object condition;
            @Nullable
            private Object thenValue;

            private ConditionalExpressionBuilder() {
            }

            public static ConditionalExpressionBuilder newBuilder() {
                return new ConditionalExpressionBuilder();
            }

            @Override
            public ConditionalExpressionBuilder when(Document booleanExpression) {
                Assert.notNull((Object)booleanExpression, (String)"'Boolean expression' must not be null!");
                this.condition = booleanExpression;
                return this;
            }

            @Override
            public ThenBuilder when(CriteriaDefinition criteria) {
                Assert.notNull((Object)criteria, (String)"Criteria must not be null!");
                this.condition = criteria;
                return this;
            }

            @Override
            public ThenBuilder when(AggregationExpression expression) {
                Assert.notNull((Object)expression, (String)"AggregationExpression field must not be null!");
                this.condition = expression;
                return this;
            }

            @Override
            public ThenBuilder when(String booleanField) {
                Assert.hasText((String)booleanField, (String)"Boolean field name must not be null or empty!");
                this.condition = Fields.field(booleanField);
                return this;
            }

            @Override
            public OtherwiseBuilder then(Object thenValue) {
                Assert.notNull((Object)thenValue, (String)"Then-value must not be null!");
                this.thenValue = thenValue;
                return this;
            }

            @Override
            public OtherwiseBuilder thenValueOf(String fieldReference) {
                Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
                this.thenValue = Fields.field(fieldReference);
                return this;
            }

            @Override
            public OtherwiseBuilder thenValueOf(AggregationExpression expression) {
                Assert.notNull((Object)expression, (String)"AggregationExpression must not be null!");
                this.thenValue = expression;
                return this;
            }

            @Override
            public Cond otherwise(Object otherwiseValue) {
                Assert.notNull((Object)otherwiseValue, (String)"Value must not be null!");
                return new Cond(this.condition, this.thenValue, otherwiseValue);
            }

            @Override
            public Cond otherwiseValueOf(String fieldReference) {
                Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
                return new Cond(this.condition, this.thenValue, Fields.field(fieldReference));
            }

            @Override
            public Cond otherwiseValueOf(AggregationExpression expression) {
                Assert.notNull((Object)expression, (String)"AggregationExpression must not be null!");
                return new Cond(this.condition, this.thenValue, expression);
            }
        }

        public static interface OtherwiseBuilder {
            public Cond otherwise(Object var1);

            public Cond otherwiseValueOf(String var1);

            public Cond otherwiseValueOf(AggregationExpression var1);
        }

        public static interface ThenBuilder {
            public OtherwiseBuilder then(Object var1);

            public OtherwiseBuilder thenValueOf(String var1);

            public OtherwiseBuilder thenValueOf(AggregationExpression var1);
        }

        public static interface WhenBuilder {
            public ThenBuilder when(Document var1);

            public ThenBuilder when(AggregationExpression var1);

            public ThenBuilder when(String var1);

            public ThenBuilder when(CriteriaDefinition var1);
        }
    }

    public static class Switch
    extends AbstractAggregationExpression {
        private Switch(Map<String, Object> values) {
            super(values);
        }

        @Override
        protected String getMongoMethod() {
            return "$switch";
        }

        public static Switch switchCases(CaseOperator ... conditions) {
            Assert.notNull((Object)conditions, (String)"Conditions must not be null!");
            return Switch.switchCases(Arrays.asList(conditions));
        }

        public static Switch switchCases(List<CaseOperator> conditions) {
            Assert.notNull(conditions, (String)"Conditions must not be null!");
            return new Switch(Collections.singletonMap("branches", new ArrayList<CaseOperator>(conditions)));
        }

        public Switch defaultTo(Object value) {
            return new Switch(this.append("default", value));
        }

        public static class CaseOperator
        implements AggregationExpression {
            private final AggregationExpression when;
            private final Object then;

            private CaseOperator(AggregationExpression when, Object then) {
                this.when = when;
                this.then = then;
            }

            public static ThenBuilder when(final AggregationExpression condition) {
                Assert.notNull((Object)condition, (String)"Condition must not be null!");
                return new ThenBuilder(){

                    @Override
                    public CaseOperator then(Object value) {
                        Assert.notNull((Object)value, (String)"Value must not be null!");
                        return new CaseOperator(condition, value);
                    }
                };
            }

            @Override
            public Document toDocument(AggregationOperationContext context) {
                Document dbo = new Document("case", (Object)this.when.toDocument(context));
                if (this.then instanceof AggregationExpression) {
                    dbo.put("then", (Object)((AggregationExpression)this.then).toDocument(context));
                } else if (this.then instanceof Field) {
                    dbo.put("then", (Object)context.getReference((Field)this.then).toString());
                } else {
                    dbo.put("then", this.then);
                }
                return dbo;
            }

            public static interface ThenBuilder {
                public CaseOperator then(Object var1);
            }
        }
    }

    public static class IfNull
    implements AggregationExpression {
        private final Object condition;
        private final Object value;

        private IfNull(Object condition, Object value) {
            this.condition = condition;
            this.value = value;
        }

        public static ThenBuilder ifNull(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new IfNullOperatorBuilder().ifNull(fieldReference);
        }

        public static ThenBuilder ifNull(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new IfNullOperatorBuilder().ifNull(expression);
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (this.condition instanceof Collection) {
                for (Object val : (Collection)this.condition) {
                    list.add(this.mapCondition(val, context));
                }
            } else {
                list.add(this.mapCondition(this.condition, context));
            }
            list.add(this.resolve(this.value, context));
            return new Document("$ifNull", list);
        }

        private Object mapCondition(Object condition, AggregationOperationContext context) {
            if (condition instanceof Field) {
                return context.getReference((Field)condition).toString();
            }
            if (condition instanceof AggregationExpression) {
                return ((AggregationExpression)condition).toDocument(context);
            }
            return condition;
        }

        private Object resolve(Object value, AggregationOperationContext context) {
            if (value instanceof Field) {
                return context.getReference((Field)value).toString();
            }
            if (value instanceof AggregationExpression) {
                return ((AggregationExpression)value).toDocument(context);
            }
            if (value instanceof Document) {
                return value;
            }
            return context.getMappedObject(new Document("$set", value)).get((Object)"$set");
        }

        static final class IfNullOperatorBuilder
        implements IfNullBuilder,
        ThenBuilder {
            @Nullable
            private List<Object> conditions = new ArrayList<Object>();

            private IfNullOperatorBuilder() {
            }

            public static IfNullOperatorBuilder newBuilder() {
                return new IfNullOperatorBuilder();
            }

            @Override
            public ThenBuilder ifNull(String fieldReference) {
                Assert.hasText((String)fieldReference, (String)"FieldReference name must not be null or empty!");
                this.conditions.add(Fields.field(fieldReference));
                return this;
            }

            @Override
            public ThenBuilder ifNull(AggregationExpression expression) {
                Assert.notNull((Object)expression, (String)"AggregationExpression name must not be null or empty!");
                this.conditions.add(expression);
                return this;
            }

            @Override
            public ThenBuilder orIfNull(String fieldReference) {
                return this.ifNull(fieldReference);
            }

            @Override
            public ThenBuilder orIfNull(AggregationExpression expression) {
                return this.ifNull(expression);
            }

            @Override
            public IfNull then(Object value) {
                return new IfNull(this.conditions, value);
            }

            @Override
            public IfNull thenValueOf(String fieldReference) {
                Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
                return new IfNull(this.conditions, Fields.field(fieldReference));
            }

            @Override
            public IfNull thenValueOf(AggregationExpression expression) {
                Assert.notNull((Object)expression, (String)"Expression must not be null!");
                return new IfNull(this.conditions, expression);
            }
        }

        public static interface ThenBuilder
        extends OrBuilder {
            public IfNull then(Object var1);

            public IfNull thenValueOf(String var1);

            public IfNull thenValueOf(AggregationExpression var1);
        }

        public static interface OrBuilder {
            public ThenBuilder orIfNull(String var1);

            public ThenBuilder orIfNull(AggregationExpression var1);
        }

        public static interface IfNullBuilder {
            public ThenBuilder ifNull(String var1);

            public ThenBuilder ifNull(AggregationExpression var1);
        }
    }

    public static class ConditionalOperatorFactory {
        @Nullable
        private final String fieldReference;
        @Nullable
        private final AggregationExpression expression;
        @Nullable
        private final CriteriaDefinition criteriaDefinition;

        public ConditionalOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            this.fieldReference = fieldReference;
            this.expression = null;
            this.criteriaDefinition = null;
        }

        public ConditionalOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            this.fieldReference = null;
            this.expression = expression;
            this.criteriaDefinition = null;
        }

        public ConditionalOperatorFactory(CriteriaDefinition criteriaDefinition) {
            Assert.notNull((Object)criteriaDefinition, (String)"CriteriaDefinition must not be null!");
            this.fieldReference = null;
            this.expression = null;
            this.criteriaDefinition = criteriaDefinition;
        }

        public Cond.OtherwiseBuilder then(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createThenBuilder().then(value);
        }

        public Cond.OtherwiseBuilder thenValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createThenBuilder().then(expression);
        }

        public Cond.OtherwiseBuilder thenValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createThenBuilder().thenValueOf(fieldReference);
        }

        private Cond.ThenBuilder createThenBuilder() {
            if (this.usesFieldRef()) {
                return Cond.newBuilder().when(this.fieldReference);
            }
            return this.usesCriteriaDefinition() ? Cond.newBuilder().when(this.criteriaDefinition) : Cond.newBuilder().when(this.expression);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }

        private boolean usesCriteriaDefinition() {
            return this.criteriaDefinition != null;
        }
    }
}

