/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.WriteConcern;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MongoAction {
    private final String collectionName;
    private final MongoActionOperation mongoActionOperation;
    @Nullable
    private final WriteConcern defaultWriteConcern;
    @Nullable
    private final Class<?> entityType;
    @Nullable
    private final Document query;
    @Nullable
    private final Document document;

    public MongoAction(@Nullable WriteConcern defaultWriteConcern, MongoActionOperation mongoActionOperation, String collectionName, @Nullable Class<?> entityType, @Nullable Document document, @Nullable Document query) {
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        Assert.notNull((Object)((Object)mongoActionOperation), (String)"MongoActionOperation must not be null!");
        this.defaultWriteConcern = defaultWriteConcern;
        this.mongoActionOperation = mongoActionOperation;
        this.collectionName = collectionName;
        this.entityType = entityType;
        this.query = query;
        this.document = document;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    @Nullable
    public WriteConcern getDefaultWriteConcern() {
        return this.defaultWriteConcern;
    }

    @Nullable
    public Class<?> getEntityType() {
        return this.entityType;
    }

    @Nullable
    public MongoActionOperation getMongoActionOperation() {
        return this.mongoActionOperation;
    }

    @Nullable
    public Document getQuery() {
        return this.query;
    }

    @Nullable
    public Document getDocument() {
        return this.document;
    }
}

