/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.GeoJsonLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPolygon;
import org.springframework.data.mongodb.core.geo.GeoJsonPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonPolygon;
import org.springframework.lang.Nullable;

public class GeoJsonModule
extends SimpleModule {
    private static final long serialVersionUID = -8723016728655643720L;

    public GeoJsonModule() {
        this.addDeserializer(GeoJsonPoint.class, new GeoJsonPointDeserializer());
        this.addDeserializer(GeoJsonMultiPoint.class, new GeoJsonMultiPointDeserializer());
        this.addDeserializer(GeoJsonLineString.class, new GeoJsonLineStringDeserializer());
        this.addDeserializer(GeoJsonMultiLineString.class, new GeoJsonMultiLineStringDeserializer());
        this.addDeserializer(GeoJsonPolygon.class, new GeoJsonPolygonDeserializer());
        this.addDeserializer(GeoJsonMultiPolygon.class, new GeoJsonMultiPolygonDeserializer());
    }

    private static class GeoJsonMultiPolygonDeserializer
    extends GeoJsonDeserializer<GeoJsonMultiPolygon> {
        private GeoJsonMultiPolygonDeserializer() {
        }

        @Override
        protected GeoJsonMultiPolygon doDeserialize(ArrayNode coordinates) {
            ArrayList<GeoJsonPolygon> polygones = new ArrayList<GeoJsonPolygon>(coordinates.size());
            for (JsonNode polygon : coordinates) {
                for (JsonNode ring : polygon) {
                    polygones.add(new GeoJsonPolygon(this.toPoints((ArrayNode)ring)));
                }
            }
            return new GeoJsonMultiPolygon(polygones);
        }
    }

    private static class GeoJsonPolygonDeserializer
    extends GeoJsonDeserializer<GeoJsonPolygon> {
        private GeoJsonPolygonDeserializer() {
        }

        @Override
        @Nullable
        protected GeoJsonPolygon doDeserialize(ArrayNode coordinates) {
            Iterator iterator = coordinates.iterator();
            if (iterator.hasNext()) {
                JsonNode ring = (JsonNode)iterator.next();
                return new GeoJsonPolygon(this.toPoints((ArrayNode)ring));
            }
            return null;
        }
    }

    private static class GeoJsonMultiLineStringDeserializer
    extends GeoJsonDeserializer<GeoJsonMultiLineString> {
        private GeoJsonMultiLineStringDeserializer() {
        }

        @Override
        protected GeoJsonMultiLineString doDeserialize(ArrayNode coordinates) {
            ArrayList<GeoJsonLineString> lines = new ArrayList<GeoJsonLineString>(coordinates.size());
            for (JsonNode lineString : coordinates) {
                if (!lineString.isArray()) continue;
                lines.add(this.toLineString((ArrayNode)lineString));
            }
            return new GeoJsonMultiLineString((List<GeoJsonLineString>)lines);
        }
    }

    private static class GeoJsonMultiPointDeserializer
    extends GeoJsonDeserializer<GeoJsonMultiPoint> {
        private GeoJsonMultiPointDeserializer() {
        }

        @Override
        protected GeoJsonMultiPoint doDeserialize(ArrayNode coordinates) {
            return new GeoJsonMultiPoint(this.toPoints(coordinates));
        }
    }

    private static class GeoJsonLineStringDeserializer
    extends GeoJsonDeserializer<GeoJsonLineString> {
        private GeoJsonLineStringDeserializer() {
        }

        @Override
        protected GeoJsonLineString doDeserialize(ArrayNode coordinates) {
            return new GeoJsonLineString(this.toPoints(coordinates));
        }
    }

    private static class GeoJsonPointDeserializer
    extends GeoJsonDeserializer<GeoJsonPoint> {
        private GeoJsonPointDeserializer() {
        }

        @Override
        @Nullable
        protected GeoJsonPoint doDeserialize(ArrayNode coordinates) {
            return this.toGeoJsonPoint(coordinates);
        }
    }

    private static abstract class GeoJsonDeserializer<T extends GeoJson<?>>
    extends JsonDeserializer<T> {
        private GeoJsonDeserializer() {
        }

        @Nullable
        public T deserialize(@Nullable JsonParser jp, @Nullable DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.readValueAsTree();
            JsonNode coordinates = node.get("coordinates");
            if (coordinates != null && coordinates.isArray()) {
                return this.doDeserialize((ArrayNode)coordinates);
            }
            return null;
        }

        @Nullable
        protected abstract T doDeserialize(ArrayNode var1);

        @Nullable
        protected GeoJsonPoint toGeoJsonPoint(@Nullable ArrayNode node) {
            if (node == null) {
                return null;
            }
            return new GeoJsonPoint(node.get(0).asDouble(), node.get(1).asDouble());
        }

        @Nullable
        protected Point toPoint(@Nullable ArrayNode node) {
            if (node == null) {
                return null;
            }
            return new Point(node.get(0).asDouble(), node.get(1).asDouble());
        }

        protected List<Point> toPoints(@Nullable ArrayNode node) {
            if (node == null) {
                return Collections.emptyList();
            }
            ArrayList<Point> points = new ArrayList<Point>(node.size());
            for (JsonNode coordinatePair : node) {
                if (!coordinatePair.isArray()) continue;
                points.add(this.toPoint((ArrayNode)coordinatePair));
            }
            return points;
        }

        protected GeoJsonLineString toLineString(ArrayNode node) {
            return new GeoJsonLineString(this.toPoints(node));
        }
    }
}

