/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import lombok.NonNull;
import org.springframework.data.mongodb.core.ExecutableAggregationOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableAggregationOperationSupport
implements ExecutableAggregationOperation {
    @NonNull
    private final MongoTemplate template;

    @Override
    public <T> ExecutableAggregationOperation.ExecutableAggregation<T> aggregateAndReturn(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ExecutableAggregationSupport<T>(this.template, domainType, null, null);
    }

    public ExecutableAggregationOperationSupport(@NonNull MongoTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template is marked non-null but is null");
        }
        this.template = template;
    }

    static class ExecutableAggregationSupport<T>
    implements ExecutableAggregationOperation.AggregationWithAggregation<T>,
    ExecutableAggregationOperation.ExecutableAggregation<T>,
    ExecutableAggregationOperation.TerminatingAggregation<T> {
        @NonNull
        private final MongoTemplate template;
        @NonNull
        private final Class<T> domainType;
        @Nullable
        private final Aggregation aggregation;
        @Nullable
        private final String collection;

        @Override
        public ExecutableAggregationOperation.AggregationWithAggregation<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty!");
            return new ExecutableAggregationSupport<T>(this.template, this.domainType, this.aggregation, collection);
        }

        @Override
        public ExecutableAggregationOperation.TerminatingAggregation<T> by(Aggregation aggregation) {
            Assert.notNull((Object)aggregation, (String)"Aggregation must not be null!");
            return new ExecutableAggregationSupport<T>(this.template, this.domainType, aggregation, this.collection);
        }

        @Override
        public AggregationResults<T> all() {
            return this.template.aggregate(this.aggregation, this.getCollectionName(this.aggregation), this.domainType);
        }

        @Override
        public CloseableIterator<T> stream() {
            return this.template.aggregateStream(this.aggregation, this.getCollectionName(this.aggregation), this.domainType);
        }

        private String getCollectionName(Aggregation aggregation) {
            TypedAggregation typedAggregation;
            if (StringUtils.hasText((String)this.collection)) {
                return this.collection;
            }
            if (aggregation instanceof TypedAggregation && (typedAggregation = (TypedAggregation)aggregation).getInputType() != null) {
                return this.template.getCollectionName(typedAggregation.getInputType());
            }
            return this.template.getCollectionName(this.domainType);
        }

        public ExecutableAggregationSupport(@NonNull MongoTemplate template, @NonNull Class<T> domainType, @Nullable Aggregation aggregation, @Nullable String collection) {
            if (template == null) {
                throw new IllegalArgumentException("template is marked non-null but is null");
            }
            if (domainType == null) {
                throw new IllegalArgumentException("domainType is marked non-null but is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.aggregation = aggregation;
            this.collection = collection;
        }
    }
}

