/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.MongoClient;
import org.bson.Document;
import org.springframework.data.mongodb.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

@ManagedResource(description="Operation Counters")
public class OperationCounters
extends AbstractMonitor {
    public OperationCounters(MongoClient mongoClient) {
        super(mongoClient);
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Insert operation count")
    public int getInsertCount() {
        return this.getOpCounter("insert");
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Query operation count")
    public int getQueryCount() {
        return this.getOpCounter("query");
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Update operation count")
    public int getUpdateCount() {
        return this.getOpCounter("update");
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Delete operation count")
    public int getDeleteCount() {
        return this.getOpCounter("delete");
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="GetMore operation count")
    public int getGetMoreCount() {
        return this.getOpCounter("getmore");
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Command operation count")
    public int getCommandCount() {
        return this.getOpCounter("command");
    }

    private int getOpCounter(String key) {
        Document opCounters = (Document)this.getServerStatus().get((Object)"opcounters");
        return (Integer)opCounters.get((Object)key);
    }
}

