/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;

public interface ExecutableFindOperation {
    public <T> ExecutableFind<T> query(Class<T> var1);

    public static interface ExecutableFind<T>
    extends FindWithCollection<T>,
    FindWithProjection<T>,
    FindDistinct {
    }

    public static interface TerminatingDistinct<T>
    extends DistinctWithQuery<T> {
        public List<T> all();
    }

    public static interface DistinctWithQuery<T>
    extends DistinctWithProjection {
        public TerminatingDistinct<T> matching(Query var1);
    }

    public static interface DistinctWithProjection {
        public <R> TerminatingDistinct<R> as(Class<R> var1);
    }

    public static interface FindDistinct {
        public TerminatingDistinct<Object> distinct(String var1);
    }

    public static interface FindWithProjection<T>
    extends FindWithQuery<T>,
    FindDistinct {
        public <R> FindWithQuery<R> as(Class<R> var1);
    }

    public static interface FindWithCollection<T>
    extends FindWithQuery<T> {
        public FindWithProjection<T> inCollection(String var1);
    }

    public static interface FindWithQuery<T>
    extends TerminatingFind<T> {
        public TerminatingFind<T> matching(Query var1);

        public TerminatingFindNear<T> near(NearQuery var1);
    }

    public static interface TerminatingFindNear<T> {
        public GeoResults<T> all();
    }

    public static interface TerminatingFind<T> {
        default public Optional<T> one() {
            return Optional.ofNullable(this.oneValue());
        }

        @Nullable
        public T oneValue();

        default public Optional<T> first() {
            return Optional.ofNullable(this.firstValue());
        }

        @Nullable
        public T firstValue();

        public List<T> all();

        public Stream<T> stream();

        public long count();

        public boolean exists();
    }
}

