/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.DBObject;
import com.mongodb.Mongo;
import java.util.Date;
import org.springframework.data.mongodb.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

@ManagedResource(description="Background Flushing Metrics")
public class BackgroundFlushingMetrics
extends AbstractMonitor {
    public BackgroundFlushingMetrics(Mongo mongo) {
        this.mongo = mongo;
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Flushes")
    public int getFlushes() {
        return this.getFlushingData("flushes", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Total ms", unit="ms")
    public int getTotalMs() {
        return this.getFlushingData("total_ms", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Average ms", unit="ms")
    public double getAverageMs() {
        return this.getFlushingData("average_ms", Double.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Last Ms", unit="ms")
    public int getLastMs() {
        return this.getFlushingData("last_ms", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Last finished")
    public Date getLastFinished() {
        return this.getLast();
    }

    private <T> T getFlushingData(String key, Class<T> targetClass) {
        DBObject mem = (DBObject)this.getServerStatus().get("backgroundFlushing");
        return (T)mem.get(key);
    }

    private Date getLast() {
        DBObject bgFlush = (DBObject)this.getServerStatus().get("backgroundFlushing");
        Date lastFinished = (Date)bgFlush.get("last_finished");
        return lastFinished;
    }
}

