/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapreduce;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import java.util.HashMap;
import java.util.Map;

public class MapReduceOptions {
    private String outputCollection;
    private String outputDatabase;
    private Boolean outputSharded;
    private MapReduceCommand.OutputType outputType = MapReduceCommand.OutputType.REPLACE;
    private String finalizeFunction;
    private Map<String, Object> scopeVariables = new HashMap<String, Object>();
    private Boolean jsMode;
    private Boolean verbose = true;
    private Integer limit;
    private Map<String, Object> extraOptions = new HashMap<String, Object>();

    public static MapReduceOptions options() {
        return new MapReduceOptions();
    }

    public MapReduceOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    public MapReduceOptions outputCollection(String collectionName) {
        this.outputCollection = collectionName;
        return this;
    }

    public MapReduceOptions outputDatabase(String outputDatabase) {
        this.outputDatabase = outputDatabase;
        return this;
    }

    public MapReduceOptions outputTypeInline() {
        this.outputType = MapReduceCommand.OutputType.INLINE;
        return this;
    }

    public MapReduceOptions outputTypeMerge() {
        this.outputType = MapReduceCommand.OutputType.MERGE;
        return this;
    }

    public MapReduceOptions outputTypeReduce() {
        this.outputType = MapReduceCommand.OutputType.REDUCE;
        return this;
    }

    public MapReduceOptions outputTypeReplace() {
        this.outputType = MapReduceCommand.OutputType.REPLACE;
        return this;
    }

    public MapReduceOptions outputSharded(boolean outputShared) {
        this.outputSharded = outputShared;
        return this;
    }

    public MapReduceOptions finalizeFunction(String finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public MapReduceOptions scopeVariables(Map<String, Object> scopeVariables) {
        this.scopeVariables = scopeVariables;
        return this;
    }

    public MapReduceOptions javaScriptMode(boolean javaScriptMode) {
        this.jsMode = javaScriptMode;
        return this;
    }

    public MapReduceOptions verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Deprecated
    public MapReduceOptions extraOption(String key, Object value) {
        this.extraOptions.put(key, value);
        return this;
    }

    @Deprecated
    public Map<String, Object> getExtraOptions() {
        return this.extraOptions;
    }

    public String getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public Boolean getJavaScriptMode() {
        return this.jsMode;
    }

    public String getOutputCollection() {
        return this.outputCollection;
    }

    public String getOutputDatabase() {
        return this.outputDatabase;
    }

    public Boolean getOutputSharded() {
        return this.outputSharded;
    }

    public MapReduceCommand.OutputType getOutputType() {
        return this.outputType;
    }

    public Map<String, Object> getScopeVariables() {
        return this.scopeVariables;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public DBObject getOptionsObject() {
        BasicDBObject cmd = new BasicDBObject();
        if (this.verbose != null) {
            cmd.put("verbose", (Object)this.verbose);
        }
        cmd.put("out", (Object)this.createOutObject());
        if (this.finalizeFunction != null) {
            cmd.put("finalize", (Object)this.finalizeFunction);
        }
        if (this.scopeVariables != null) {
            cmd.put("scope", this.scopeVariables);
        }
        if (this.limit != null) {
            cmd.put("limit", (Object)this.limit);
        }
        if (!this.extraOptions.keySet().isEmpty()) {
            cmd.putAll(this.extraOptions);
        }
        return cmd;
    }

    protected BasicDBObject createOutObject() {
        BasicDBObject out = new BasicDBObject();
        switch (this.outputType) {
            case INLINE: {
                out.put("inline", (Object)1);
                break;
            }
            case REPLACE: {
                out.put("replace", (Object)this.outputCollection);
                break;
            }
            case MERGE: {
                out.put("merge", (Object)this.outputCollection);
                break;
            }
            case REDUCE: {
                out.put("reduce", (Object)this.outputCollection);
            }
        }
        if (this.outputDatabase != null) {
            out.put("db", (Object)this.outputDatabase);
        }
        if (this.outputSharded != null) {
            out.put("sharded", (Object)this.outputSharded);
        }
        return out;
    }
}

