/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.ReflectiveDBCollectionInvoker;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.util.Assert;

public class DefaultIndexOperations
implements IndexOperations {
    private static final String PARTIAL_FILTER_EXPRESSION_KEY = "partialFilterExpression";
    private final MongoOperations mongoOperations;
    private final String collectionName;
    private final QueryMapper mapper;
    private final Class<?> type;

    public DefaultIndexOperations(MongoOperations mongoOperations, String collectionName) {
        this(mongoOperations, collectionName, null);
    }

    public DefaultIndexOperations(MongoOperations mongoOperations, String collectionName, Class<?> type) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null!");
        Assert.notNull((Object)collectionName, (String)"Collection name can not be null!");
        this.mongoOperations = mongoOperations;
        this.collectionName = collectionName;
        this.mapper = new QueryMapper(mongoOperations.getConverter());
        this.type = type;
    }

    @Override
    public void ensureIndex(final IndexDefinition indexDefinition) {
        this.mongoOperations.execute(this.collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                DBObject indexOptions = indexDefinition.getIndexOptions();
                if (indexOptions != null && indexOptions.containsField(DefaultIndexOperations.PARTIAL_FILTER_EXPRESSION_KEY)) {
                    Assert.isInstanceOf(DBObject.class, (Object)indexOptions.get(DefaultIndexOperations.PARTIAL_FILTER_EXPRESSION_KEY));
                    indexOptions.put(DefaultIndexOperations.PARTIAL_FILTER_EXPRESSION_KEY, (Object)DefaultIndexOperations.this.mapper.getMappedObject((DBObject)indexOptions.get(DefaultIndexOperations.PARTIAL_FILTER_EXPRESSION_KEY), this.lookupPersistentEntity(DefaultIndexOperations.this.type, DefaultIndexOperations.this.collectionName)));
                }
                if (indexOptions != null) {
                    collection.createIndex(indexDefinition.getIndexKeys(), indexOptions);
                } else {
                    collection.createIndex(indexDefinition.getIndexKeys());
                }
                return null;
            }

            private MongoPersistentEntity<?> lookupPersistentEntity(Class<?> entityType, String collection) {
                if (entityType != null) {
                    return (MongoPersistentEntity)DefaultIndexOperations.this.mongoOperations.getConverter().getMappingContext().getPersistentEntity(entityType);
                }
                Collection entities = DefaultIndexOperations.this.mongoOperations.getConverter().getMappingContext().getPersistentEntities();
                for (MongoPersistentEntity entity : entities) {
                    if (!entity.getCollection().equals(collection)) continue;
                    return entity;
                }
                return null;
            }
        });
    }

    @Override
    public void dropIndex(final String name) {
        this.mongoOperations.execute(this.collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                collection.dropIndex(name);
                return null;
            }
        });
    }

    @Override
    public void dropAllIndexes() {
        this.dropIndex("*");
    }

    @Override
    @Deprecated
    public void resetIndexCache() {
        this.mongoOperations.execute(this.collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                ReflectiveDBCollectionInvoker.resetIndexCache(collection);
                return null;
            }
        });
    }

    @Override
    public List<IndexInfo> getIndexInfo() {
        return this.mongoOperations.execute(this.collectionName, new CollectionCallback<List<IndexInfo>>(){

            @Override
            public List<IndexInfo> doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                List dbObjectList = collection.getIndexInfo();
                return this.getIndexData(dbObjectList);
            }

            private List<IndexInfo> getIndexData(List<DBObject> dbObjectList) {
                ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>();
                for (DBObject ix : dbObjectList) {
                    indexInfoList.add(IndexInfo.indexInfoOf(ix));
                }
                return indexInfoList;
            }
        });
    }
}

