/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.query;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.SimplePropertyPathAccessor;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Contract;
import org.springframework.util.ObjectUtils;

public class PredicateQueryCreator
extends AbstractQueryCreator<KeyValueQuery<Predicate<?>>, Predicate<?>> {
    private static final Comparator<?> COMPARATOR = Comparator.nullsFirst(Comparator.naturalOrder());

    public PredicateQueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
    }

    protected Predicate<?> create(Part part, Iterator<Object> iterator) {
        PredicateBuilder builder = PredicateBuilder.propertyValueOf(part);
        return switch (part.getType()) {
            case Part.Type.TRUE -> builder.isTrue();
            case Part.Type.FALSE -> builder.isFalse();
            case Part.Type.SIMPLE_PROPERTY -> builder.isEqualTo(iterator.next());
            case Part.Type.NEGATING_SIMPLE_PROPERTY -> builder.isEqualTo(iterator.next()).negate();
            case Part.Type.IS_NULL -> builder.isNull();
            case Part.Type.IS_NOT_NULL -> builder.isNotNull();
            case Part.Type.LIKE -> builder.contains(iterator.next());
            case Part.Type.NOT_LIKE -> builder.contains(iterator.next()).negate();
            case Part.Type.STARTING_WITH -> builder.startsWith(iterator.next());
            case Part.Type.AFTER, Part.Type.GREATER_THAN -> builder.isGreaterThan(iterator.next());
            case Part.Type.GREATER_THAN_EQUAL -> builder.isGreaterThanEqual(iterator.next());
            case Part.Type.BEFORE, Part.Type.LESS_THAN -> builder.isLessThan(iterator.next());
            case Part.Type.LESS_THAN_EQUAL -> builder.isLessThanEqual(iterator.next());
            case Part.Type.ENDING_WITH -> builder.endsWith(iterator.next());
            case Part.Type.BETWEEN -> builder.isGreaterThan(iterator.next()).and(builder.isLessThan(iterator.next()));
            case Part.Type.REGEX -> builder.matches(iterator.next());
            case Part.Type.IN -> builder.in(iterator.next());
            case Part.Type.NOT_IN -> builder.in(iterator.next()).negate();
            default -> throw new InvalidDataAccessApiUsageException(String.format("Found invalid part '%s' in query", part.getType()));
        };
    }

    protected Predicate<?> and(Part part, Predicate<?> base, Iterator<Object> iterator) {
        return base.and((Predicate<?>)this.create(part, (Iterator)iterator));
    }

    protected Predicate<?> or(Predicate<?> base, Predicate<?> criteria) {
        return base.or(criteria);
    }

    protected KeyValueQuery<Predicate<?>> complete(@Nullable Predicate<?> criteria, Sort sort) {
        return criteria == null ? new KeyValueQuery(it -> true, sort) : new KeyValueQuery(criteria, sort);
    }

    static class PredicateBuilder {
        private final Part part;

        public PredicateBuilder(Part part) {
            this.part = part;
        }

        static <T> Comparator<T> comparator() {
            return COMPARATOR;
        }

        static PredicateBuilder propertyValueOf(Part part) {
            return new PredicateBuilder(part);
        }

        public Predicate<Object> isTrue() {
            return new ValueComparingPredicate(this.part.getProperty(), true);
        }

        public Predicate<Object> isFalse() {
            return new ValueComparingPredicate(this.part.getProperty(), false);
        }

        @Contract(value="_ -> new")
        public Predicate<Object> isEqualTo(@Nullable Object value) {
            return new ValueComparingPredicate(this.part.getProperty(), o -> {
                if (!ObjectUtils.nullSafeEquals((Object)Part.IgnoreCaseType.NEVER, (Object)this.part.shouldIgnoreCase()) && o instanceof String) {
                    String s1 = (String)o;
                    if (value instanceof String) {
                        String s2 = (String)value;
                        return s1.equalsIgnoreCase(s2);
                    }
                }
                return ObjectUtils.nullSafeEquals((Object)o, (Object)value);
            });
        }

        public Predicate<Object> isNull() {
            return new ValueComparingPredicate(this.part.getProperty(), Objects::isNull);
        }

        public Predicate<Object> isNotNull() {
            return this.isNull().negate();
        }

        @Contract(value="_ -> new")
        public Predicate<Object> isLessThan(@Nullable Object value) {
            return new ValueComparingPredicate(this.part.getProperty(), o -> PredicateBuilder.comparator().compare(o, value) < 0);
        }

        @Contract(value="_ -> new")
        public Predicate<Object> isLessThanEqual(@Nullable Object value) {
            return new ValueComparingPredicate(this.part.getProperty(), o -> PredicateBuilder.comparator().compare(o, value) <= 0);
        }

        @Contract(value="_ -> new")
        public Predicate<Object> isGreaterThan(@Nullable Object value) {
            return new ValueComparingPredicate(this.part.getProperty(), o -> PredicateBuilder.comparator().compare(o, value) > 0);
        }

        @Contract(value="_ -> new")
        public Predicate<Object> isGreaterThanEqual(@Nullable Object value) {
            return new ValueComparingPredicate(this.part.getProperty(), o -> PredicateBuilder.comparator().compare(o, value) >= 0);
        }

        @Contract(value="!null -> new")
        public Predicate<Object> matches(Pattern pattern) {
            return new ValueComparingPredicate(this.part.getProperty(), o -> {
                if (o == null) {
                    return false;
                }
                return pattern.matcher(o.toString()).find();
            });
        }

        @Contract(value="_ -> new")
        public Predicate<Object> matches(@Nullable Object value) {
            return new ValueComparingPredicate(this.part.getProperty(), o -> {
                if (o == null || value == null) {
                    return ObjectUtils.nullSafeEquals((Object)o, (Object)value);
                }
                if (value instanceof Pattern) {
                    Pattern pattern = (Pattern)value;
                    return pattern.matcher(o.toString()).find();
                }
                return o.toString().matches(value.toString());
            });
        }

        @Contract(value="!null -> new")
        public Predicate<Object> matches(String regex) {
            return this.matches(Pattern.compile(regex));
        }

        @Contract(value="!null -> new")
        public Predicate<Object> in(Object value) {
            return new ValueComparingPredicate(this.part.getProperty(), o -> {
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    if (o instanceof Collection) {
                        Collection subSet = (Collection)o;
                        return collection.containsAll(subSet);
                    }
                    return collection.contains(o);
                }
                if (ObjectUtils.isArray((Object)value)) {
                    return ObjectUtils.containsElement((Object[])ObjectUtils.toObjectArray((Object)value), (Object)value);
                }
                return false;
            });
        }

        @Contract(value="_ -> new")
        public Predicate<Object> contains(@Nullable Object value) {
            return new ValueComparingPredicate(this.part.getProperty(), o -> {
                if (o == null) {
                    return false;
                }
                if (o instanceof Collection) {
                    Collection collection = (Collection)o;
                    return collection.contains(value);
                }
                if (ObjectUtils.isArray((Object)o)) {
                    return ObjectUtils.containsElement((Object[])ObjectUtils.toObjectArray((Object)o), (Object)value);
                }
                if (o instanceof Map) {
                    Map map = (Map)o;
                    return map.containsValue(value);
                }
                if (value == null) {
                    return false;
                }
                String s = o.toString();
                if (ObjectUtils.nullSafeEquals((Object)Part.IgnoreCaseType.NEVER, (Object)this.part.shouldIgnoreCase())) {
                    return s.contains(value.toString());
                }
                return s.toLowerCase().contains(value.toString().toLowerCase());
            });
        }

        @Contract(value="!null -> new")
        public Predicate<Object> startsWith(Object value) {
            return new ValueComparingPredicate(this.part.getProperty(), o -> {
                if (!(o instanceof String)) {
                    return false;
                }
                String s = (String)o;
                if (ObjectUtils.nullSafeEquals((Object)Part.IgnoreCaseType.NEVER, (Object)this.part.shouldIgnoreCase())) {
                    return s.startsWith(value.toString());
                }
                return s.toLowerCase().startsWith(value.toString().toLowerCase());
            });
        }

        @Contract(value="!null -> new")
        public Predicate<Object> endsWith(Object value) {
            return new ValueComparingPredicate(this.part.getProperty(), o -> {
                if (!(o instanceof String)) {
                    return false;
                }
                String s = (String)o;
                if (ObjectUtils.nullSafeEquals((Object)Part.IgnoreCaseType.NEVER, (Object)this.part.shouldIgnoreCase())) {
                    return s.endsWith(value.toString());
                }
                return s.toLowerCase().endsWith(value.toString().toLowerCase());
            });
        }
    }

    static class ValueComparingPredicate
    implements Predicate<Object> {
        private final PropertyPath path;
        private final Function<@Nullable Object, Boolean> check;

        public ValueComparingPredicate(PropertyPath path, @Nullable Object expected) {
            this(path, (Object value) -> ObjectUtils.nullSafeEquals((Object)value, (Object)expected));
        }

        public ValueComparingPredicate(PropertyPath path, Function<@Nullable Object, Boolean> check) {
            this.path = path;
            this.check = check;
        }

        @Override
        public boolean test(Object o) {
            Object value = new SimplePropertyPathAccessor(o).getValue(this.path);
            return this.check.apply(value);
        }
    }
}

