/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core.mapping;

import org.jspecify.annotations.Nullable;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.keyvalue.core.mapping.AnnotationBasedKeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.ClassNameKeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BasicKeyValuePersistentEntity<T, P extends KeyValuePersistentProperty<P>>
extends BasicPersistentEntity<T, P>
implements KeyValuePersistentEntity<T, P> {
    private static final ValueExpressionParser PARSER = ValueExpressionParser.create(SpelExpressionParser::new);
    private final @Nullable ValueExpression keyspaceExpression;
    private final String keyspace;

    public BasicKeyValuePersistentEntity(TypeInformation<T> information) {
        this(information, (String)null);
    }

    public BasicKeyValuePersistentEntity(TypeInformation<T> information, @Nullable KeySpaceResolver keySpaceResolver) {
        this(information, keySpaceResolver != null ? keySpaceResolver.resolveKeySpace(information.getType()) : null);
    }

    private BasicKeyValuePersistentEntity(TypeInformation<T> information, @Nullable String keyspace) {
        super(information);
        if (StringUtils.hasText((String)keyspace)) {
            this.keyspace = keyspace;
            this.keyspaceExpression = null;
        } else {
            Class type = information.getType();
            String detectedKeyspace = AnnotationBasedKeySpaceResolver.INSTANCE.resolveKeySpace(type);
            if (StringUtils.hasText((String)detectedKeyspace)) {
                this.keyspace = detectedKeyspace;
                this.keyspaceExpression = BasicKeyValuePersistentEntity.detectExpression(detectedKeyspace);
            } else {
                this.keyspace = ClassNameKeySpaceResolver.INSTANCE.resolveKeySpace(type);
                this.keyspaceExpression = null;
            }
        }
    }

    private static @Nullable ValueExpression detectExpression(String potentialExpression) {
        ValueExpression expression = PARSER.parse(potentialExpression);
        return expression.isLiteral() ? null : expression;
    }

    @Override
    public String getKeySpace() {
        return this.keyspaceExpression == null ? this.keyspace : ObjectUtils.nullSafeToString((Object)this.keyspaceExpression.evaluate(this.getValueEvaluationContext(null)));
    }
}

