/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.support;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import java.util.ArrayList;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.querydsl.QSort;
import org.springframework.util.Assert;

abstract class KeyValueQuerydslUtils {
    private KeyValueQuerydslUtils() {
    }

    static OrderSpecifier<?>[] toOrderSpecifier(Sort sort, PathBuilder<?> builder) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        Assert.notNull(builder, (String)"Builder must not be null");
        ArrayList specifiers = null;
        if (sort instanceof QSort) {
            specifiers = ((QSort)sort).getOrderSpecifiers();
        } else {
            specifiers = new ArrayList();
            for (Sort.Order order : sort) {
                specifiers.add(KeyValueQuerydslUtils.toOrderSpecifier(order, builder));
            }
        }
        return specifiers.toArray(new OrderSpecifier[specifiers.size()]);
    }

    private static OrderSpecifier<?> toOrderSpecifier(Sort.Order order, PathBuilder<?> builder) {
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, KeyValueQuerydslUtils.buildOrderPropertyPathFrom(order, builder), KeyValueQuerydslUtils.toQueryDslNullHandling(order.getNullHandling()));
    }

    private static Expression<?> buildOrderPropertyPathFrom(Sort.Order order, PathBuilder<?> builder) {
        Assert.notNull((Object)order, (String)"Order must not be null");
        Assert.notNull(builder, (String)"Builder must not be null");
        Object sortPropertyExpression = builder;
        for (PropertyPath path = PropertyPath.from((String)order.getProperty(), (Class)builder.getType()); path != null; path = path.next()) {
            sortPropertyExpression = !path.hasNext() && order.isIgnoreCase() ? Expressions.stringPath((Path)((Path)sortPropertyExpression), (String)path.getSegment()).lower() : Expressions.path((Class)path.getType(), (Path)((Path)sortPropertyExpression), (String)path.getSegment());
        }
        return sortPropertyExpression;
    }

    private static OrderSpecifier.NullHandling toQueryDslNullHandling(Sort.NullHandling nullHandling) {
        Assert.notNull((Object)nullHandling, (String)"NullHandling must not be null");
        switch (nullHandling) {
            case NULLS_FIRST: {
                return OrderSpecifier.NullHandling.NullsFirst;
            }
            case NULLS_LAST: {
                return OrderSpecifier.NullHandling.NullsLast;
            }
        }
        return OrderSpecifier.NullHandling.Default;
    }
}

